/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest.documents;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.schema.beans.DocumentFile;
import net.webpdf.wsclient.schema.beans.HistoryEntry;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.connection.http.HttpRestRequest;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.documents.DocumentManager;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.session.rest.documents.RestDocumentState;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDocumentManager<T_REST_DOCUMENT extends RestDocument>
implements DocumentManager<T_REST_DOCUMENT> {
    @NotNull
    private final Map<String, T_REST_DOCUMENT> documentMap = new ConcurrentHashMap<String, T_REST_DOCUMENT>();
    @NotNull
    private final RestSession<T_REST_DOCUMENT> session;
    @NotNull
    private final AtomicBoolean documentHistoryActive = new AtomicBoolean(false);

    public AbstractDocumentManager(@NotNull RestSession<T_REST_DOCUMENT> session) {
        this.session = session;
    }

    @Override
    @NotNull
    public RestSession<T_REST_DOCUMENT> getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public synchronized T_REST_DOCUMENT synchronize(@NotNull DocumentFile documentFile) throws ResultException {
        if (documentFile.getDocumentId() != null && this.containsDocument(documentFile.getDocumentId())) {
            this.synchronizeDocumentInfo(documentFile);
            return this.getDocument(documentFile.getDocumentId());
        }
        return this.createDocument(documentFile);
    }

    @Override
    @NotNull
    public synchronized List<T_REST_DOCUMENT> synchronize() throws ResultException {
        DocumentFile[] documentFileList = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "documents/list", null).executeRequest(DocumentFile[].class);
        if (documentFileList == null) {
            throw new ClientResultException(Error.HTTP_IO_ERROR);
        }
        this.documentMap.clear();
        for (DocumentFile documentFile : documentFileList) {
            this.synchronize(documentFile);
        }
        return this.getDocuments();
    }

    @Override
    @NotNull
    public String getDocumentID(@NotNull DocumentFile document) throws ResultException {
        String documentId = document.getDocumentId();
        if (documentId != null) {
            return documentId;
        }
        throw new ClientResultException(Error.INVALID_DOCUMENT);
    }

    @Override
    @NotNull
    public T_REST_DOCUMENT getDocument(@NotNull String documentId) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        return (T_REST_DOCUMENT)((RestDocument)this.documentMap.get(documentId));
    }

    @Override
    @NotNull
    public List<T_REST_DOCUMENT> getDocuments() {
        return new ArrayList<T_REST_DOCUMENT>(this.documentMap.values());
    }

    @Override
    public boolean containsDocument(@NotNull String documentId) {
        return this.documentMap.containsKey(documentId);
    }

    @Override
    public void downloadDocument(@NotNull String documentId, @NotNull OutputStream outputStream) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        HttpRestRequest.createRequest(this.session).setAcceptHeader(DataFormat.OCTET_STREAM.getMimeType()).buildRequest(HttpMethod.GET, "documents/" + documentId, null).executeRequest(outputStream);
    }

    @Override
    public void downloadDocument(@Nullable RestDocument document, @NotNull OutputStream outputStream) throws ResultException {
        if (document == null) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        this.downloadDocument(document.getDocumentId(), outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public T_REST_DOCUMENT uploadDocument(@NotNull File file) throws ResultException {
        try (FileInputStream data = FileUtils.openInputStream((File)file);){
            T_REST_DOCUMENT T_REST_DOCUMENT = this.uploadDocument(data, file.getName());
            return T_REST_DOCUMENT;
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_SOURCE_DOCUMENT, ex);
        }
    }

    @Override
    @NotNull
    public T_REST_DOCUMENT uploadDocument(@NotNull InputStream data, @NotNull String fileName) throws ResultException {
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.LEGACY);
            builder.setCharset(StandardCharsets.UTF_8);
            builder.addBinaryBody("filedata", IOUtils.toByteArray((InputStream)data), ContentType.DEFAULT_BINARY, fileName);
            HttpEntity entity = builder.build();
            ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
            parameters.add((NameValuePair)new BasicNameValuePair("history", Boolean.toString(this.documentHistoryActive.get())));
            URI uri = this.session.getURI("documents", parameters);
            DocumentFile documentFile = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, uri, entity).executeRequest(DocumentFile.class);
            if (documentFile == null) {
                throw new ClientResultException(Error.INVALID_DOCUMENT);
            }
            return this.synchronize(documentFile);
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_SOURCE_DOCUMENT, ex);
        }
    }

    @Override
    public void deleteDocument(@NotNull String documentId) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.DELETE, "documents/" + documentId, null).executeRequest(Object.class);
        this.documentMap.remove(documentId);
    }

    @Override
    @NotNull
    public T_REST_DOCUMENT renameDocument(@NotNull String documentId, @NotNull String fileName) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        T_REST_DOCUMENT restDocument = this.getDocument(documentId);
        DocumentFile documentFile = restDocument.getDocumentFile();
        documentFile.setFileName(fileName);
        documentFile = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "documents/" + documentId + "/update", this.prepareHttpEntity(documentFile)).executeRequest(DocumentFile.class);
        if (documentFile == null) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        return this.synchronize(documentFile);
    }

    @Override
    public boolean isDocumentHistoryActive() {
        return this.documentHistoryActive.get();
    }

    @Override
    public synchronized void setDocumentHistoryActive(boolean documentHistoryActive) throws ResultException {
        this.documentHistoryActive.set(documentHistoryActive);
        if (documentHistoryActive) {
            for (RestDocument document : this.getDocuments()) {
                this.synchronizeDocumentHistory(document.getDocumentId());
            }
        }
    }

    @Override
    @NotNull
    public List<HistoryEntry> getDocumentHistory(@NotNull String documentId) throws ResultException {
        if (!this.isDocumentHistoryActive()) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        return this.getDocument(documentId).getHistory();
    }

    @Override
    @NotNull
    public HistoryEntry getDocumentHistoryEntry(@NotNull String documentId, int historyId) throws ResultException {
        if (!this.isDocumentHistoryActive()) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        return this.getDocument(documentId).getHistoryEntry(historyId);
    }

    @Override
    @Nullable
    public synchronized HistoryEntry updateDocumentHistory(@NotNull String documentId, @NotNull HistoryEntry historyEntry) throws ResultException {
        if (!this.isDocumentHistoryActive()) {
            throw new ClientResultException(Error.INVALID_HISTORY_DATA);
        }
        if (!this.containsDocument(documentId)) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        RestDocument restDocument = (RestDocument)this.documentMap.get(documentId);
        int historyId = historyEntry.getId();
        HistoryEntry resultHistoryBean = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.PUT, "documents/" + documentId + "/history/" + historyId, this.prepareHttpEntity(historyEntry)).executeRequest(HistoryEntry.class);
        restDocument = this.synchronizeDocumentInfo(restDocument.getDocumentFile());
        if (resultHistoryBean != null) {
            this.accessInternalState(restDocument).updateHistoryEntry(resultHistoryBean);
        }
        return resultHistoryBean;
    }

    @NotNull
    protected abstract T_REST_DOCUMENT createDocument(@NotNull String var1) throws ResultException;

    @NotNull
    private T_REST_DOCUMENT createDocument(@NotNull DocumentFile documentFile) throws ResultException {
        String documentId = documentFile.getDocumentId();
        if (documentId == null) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        T_REST_DOCUMENT restDocument = this.createDocument(documentId);
        this.accessInternalState(restDocument).setDocumentFile(documentFile);
        this.documentMap.put(documentId, restDocument);
        this.synchronizeDocumentInfo(documentFile);
        return restDocument;
    }

    @NotNull
    private synchronized T_REST_DOCUMENT synchronizeDocumentInfo(@NotNull DocumentFile DocumentFile2) throws ResultException {
        String documentId = this.getDocumentID(DocumentFile2);
        DocumentFile documentFile = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "documents/" + documentId + "/info", null).executeRequest(DocumentFile.class);
        if (documentFile == null || (documentId = documentFile.getDocumentId()) == null) {
            throw new ClientResultException(Error.INVALID_DOCUMENT);
        }
        RestDocument restDocument = (RestDocument)this.documentMap.get(documentId);
        this.accessInternalState(restDocument).setDocumentFile(documentFile);
        if (this.isDocumentHistoryActive()) {
            this.synchronizeDocumentHistory(documentId);
        }
        return (T_REST_DOCUMENT)restDocument;
    }

    private synchronized void synchronizeDocumentHistory(@NotNull String documentId) throws ResultException {
        T_REST_DOCUMENT restDocument = this.getDocument(documentId);
        HistoryEntry[] history = HttpRestRequest.createRequest(this.getSession()).buildRequest(HttpMethod.GET, "documents/" + documentId + "/history", null).executeRequest(HistoryEntry[].class);
        if (history != null) {
            for (HistoryEntry historyEntry : history) {
                this.accessInternalState(restDocument).updateHistoryEntry(historyEntry);
            }
        }
    }

    @NotNull
    private <T> HttpEntity prepareHttpEntity(@NotNull T parameter) throws ResultException {
        try {
            return new StringEntity(SerializeHelper.toJSON(parameter), ContentType.create((String)DataFormat.JSON.getMimeType(), (Charset)StandardCharsets.UTF_8));
        }
        catch (UnsupportedCharsetException ex) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE, ex);
        }
    }

    @NotNull
    protected abstract RestDocumentState<T_REST_DOCUMENT> accessInternalState(@NotNull T_REST_DOCUMENT var1);
}

