/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest;

import java.io.IOException;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.schema.beans.User;
import net.webpdf.wsclient.session.AbstractSession;
import net.webpdf.wsclient.session.auth.AuthProvider;
import net.webpdf.wsclient.session.connection.SessionContext;
import net.webpdf.wsclient.session.connection.http.HttpAuthorizationHandler;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.connection.http.HttpRestRequest;
import net.webpdf.wsclient.session.rest.AdministrationManager;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.documents.DocumentManager;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.webservice.WebServiceProtocol;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRestSession<T_REST_DOCUMENT extends RestDocument>
extends AbstractSession
implements RestSession<T_REST_DOCUMENT> {
    @NotNull
    private static final String INFO_PATH = "authentication/user/info/";
    @NotNull
    private static final String LOGOUT_PATH = "authentication/user/logout/";
    @Nullable
    private final User user;
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private final DocumentManager<T_REST_DOCUMENT> documentManager = this.createDocumentManager();
    @NotNull
    private final AdministrationManager<T_REST_DOCUMENT> administrationManager = this.createAdministrationManager();

    public AbstractRestSession(@NotNull SessionContext serverContext, @NotNull AuthProvider authProvider) throws ResultException {
        super(WebServiceProtocol.REST, serverContext, authProvider);
        RequestConfig clientConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
        HttpAuthorizationHandler requestAuthorization = new HttpAuthorizationHandler(this);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(clientConfig).addExecInterceptorAfter(ChainElement.REDIRECT.name(), requestAuthorization.getExecChainHandlerName(), (ExecChainHandler)requestAuthorization);
        if (this.getSessionContext().getProxy() != null) {
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(this.getSessionContext().getProxy().getHost()));
        }
        if (serverContext.getTlsContext() != null) {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(serverContext.getTlsContext().create(), (hostname, session) -> true);
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registry));
        }
        this.httpClient = httpClientBuilder.build();
        this.user = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, INFO_PATH, null).executeRequest(User.class);
    }

    @Override
    @NotNull
    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    @NotNull
    public DocumentManager<T_REST_DOCUMENT> getDocumentManager() {
        return this.documentManager;
    }

    @Override
    @NotNull
    public AdministrationManager<T_REST_DOCUMENT> getAdministrationManager() {
        return this.administrationManager;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public void close() throws ResultException {
        ClientResultException resultException = null;
        try {
            HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, LOGOUT_PATH, null).executeRequest(Object.class);
        }
        finally {
            try {
                this.httpClient.close();
            }
            catch (IOException ex) {
                resultException = new ClientResultException(Error.HTTP_IO_ERROR, ex);
            }
        }
        if (resultException != null) {
            throw resultException;
        }
    }

    @NotNull
    protected abstract DocumentManager<T_REST_DOCUMENT> createDocumentManager();

    @NotNull
    protected abstract AdministrationManager<T_REST_DOCUMENT> createAdministrationManager();
}

