/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.connection.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.stream.StreamSource;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.exception.ServerResultException;
import net.webpdf.wsclient.openapi.WebserviceException;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.auth.material.AuthMaterial;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRestRequest {
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private final RestSession<?> session;
    @Nullable
    private String acceptHeader = DataFormat.JSON.getMimeType();
    @Nullable
    private HttpUriRequest httpUriRequest;

    private HttpRestRequest(@NotNull RestSession<?> session) {
        this.session = session;
        this.httpClient = session.getHttpClient();
    }

    @NotNull
    public static HttpRestRequest createRequest(@NotNull RestSession<?> session) {
        return new HttpRestRequest(session);
    }

    @NotNull
    public HttpRestRequest setAcceptHeader(@NotNull String mimeType) {
        this.acceptHeader = mimeType;
        return this;
    }

    @NotNull
    public HttpRestRequest buildRequest(@NotNull HttpMethod httpMethod, @NotNull String path, @Nullable HttpEntity httpEntity) throws ResultException {
        URI uri = this.session.getURI(path);
        return this.buildRequest(httpMethod, uri, httpEntity, null);
    }

    @NotNull
    public HttpRestRequest buildRequest(@NotNull HttpMethod httpMethod, @NotNull String path, @Nullable HttpEntity httpEntity, @Nullable AuthMaterial authMaterial) throws ResultException {
        URI uri = this.session.getURI(path);
        return this.buildRequest(httpMethod, uri, httpEntity, authMaterial);
    }

    @NotNull
    public HttpRestRequest buildRequest(@NotNull HttpMethod httpMethod, @NotNull URI uri, @Nullable HttpEntity httpEntity) throws ResultException {
        return this.buildRequest(httpMethod, uri, httpEntity, null);
    }

    @NotNull
    public HttpRestRequest buildRequest(@NotNull HttpMethod httpMethod, @NotNull URI uri, @Nullable HttpEntity httpEntity, @Nullable AuthMaterial authMaterial) throws ResultException {
        Header authorizationHeader;
        switch (httpMethod) {
            case GET: {
                this.httpUriRequest = new HttpGet(uri);
                break;
            }
            case POST: {
                this.httpUriRequest = new HttpPost(uri);
                break;
            }
            case DELETE: {
                this.httpUriRequest = new HttpDelete(uri);
                break;
            }
            case PUT: {
                this.httpUriRequest = new HttpPut(uri);
                break;
            }
            default: {
                throw new ClientResultException(Error.UNKNOWN_HTTP_METHOD);
            }
        }
        this.httpUriRequest.addHeader("Accept", (Object)this.acceptHeader);
        Header header = authorizationHeader = authMaterial != null ? authMaterial.getAuthHeader() : this.session.getAuthMaterial().getAuthHeader();
        if (authorizationHeader != null) {
            this.httpUriRequest.addHeader(authorizationHeader);
        }
        if (httpEntity != null) {
            this.httpUriRequest.setEntity(httpEntity);
        }
        return this;
    }

    private void checkResponse(@NotNull ClassicHttpResponse httpResponse) throws ResultException {
        int code = httpResponse.getCode();
        if (code == 200) {
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            throw new ClientResultException(Error.HTTP_EMPTY_ENTITY);
        }
        String exceptionMessage = "";
        String contentType = httpEntity.getContentType();
        if (DataFormat.JSON.matches(contentType)) {
            WebserviceException wsException = SerializeHelper.fromJSON(httpEntity, WebserviceException.class);
            if (wsException.getErrorCode() != 0) {
                throw new ServerResultException(wsException);
            }
        } else {
            try {
                exceptionMessage = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | ParseException ex) {
                throw new ClientResultException(Error.HTTP_CUSTOM_ERROR, (Exception)ex);
            }
        }
        throw new ClientResultException(Error.HTTP_CUSTOM_ERROR).appendMessage(code + " " + httpResponse.getReasonPhrase() + "\n" + exceptionMessage);
    }

    public void executeRequest(@NotNull OutputStream outputStream) throws ResultException {
        try {
            this.httpClient.execute((ClassicHttpRequest)this.httpUriRequest, response -> {
                response.getEntity().writeTo(outputStream);
                return null;
            });
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.HTTP_IO_ERROR, ex);
        }
    }

    @Nullable
    public <T> T executeRequest(@NotNull Class<T> type) throws ResultException {
        try {
            return (T)this.httpClient.execute((ClassicHttpRequest)this.httpUriRequest, response -> {
                try {
                    this.checkResponse(response);
                }
                catch (ResultException ex) {
                    throw new IOException(ex);
                }
                HttpEntity httpEntity = response.getEntity();
                ContentType contentType = httpEntity.getContentType() == null ? ContentType.DEFAULT_TEXT : ContentType.create((String)httpEntity.getContentType(), (Charset)StandardCharsets.UTF_8);
                String mimeType = contentType.getMimeType();
                Charset charset = contentType.getCharset() != null ? contentType.getCharset() : StandardCharsets.UTF_8;
                String value = EntityUtils.toString((HttpEntity)httpEntity, (Charset)charset);
                if (StringUtils.isEmpty((CharSequence)value)) {
                    return null;
                }
                if (!DataFormat.JSON.matches(mimeType)) {
                    return null;
                }
                StringReader stringReader = new StringReader(value);
                try {
                    StreamSource streamSource = new StreamSource(stringReader);
                    Object t = SerializeHelper.fromJSON(streamSource, type);
                    stringReader.close();
                    return t;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stringReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ResultException ex) {
                        throw new IOException(ex);
                    }
                }
            });
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof ResultException) {
                throw (ResultException)ex.getCause();
            }
            throw new ClientResultException(Error.HTTP_IO_ERROR, ex);
        }
    }
}

