/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.connection.http;

import java.io.IOException;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.connection.http.HttpExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.jetbrains.annotations.NotNull;

public class HttpAuthorizationHandler
implements HttpExecChainHandler {
    @NotNull
    private final Session session;

    public HttpAuthorizationHandler(@NotNull Session session) {
        this.session = session;
    }

    public ClassicHttpResponse execute(@NotNull ClassicHttpRequest classicHttpRequest, @NotNull ExecChain.Scope scope, @NotNull ExecChain execChain) throws IOException, HttpException {
        try {
            Header authorizationHeader;
            if (!classicHttpRequest.containsHeader("Authorization") && (authorizationHeader = this.session.getAuthMaterial().getAuthHeader()) != null) {
                classicHttpRequest.addHeader(authorizationHeader);
            }
        }
        catch (ResultException ex) {
            throw new IOException(ex);
        }
        return execChain.proceed(classicHttpRequest, scope);
    }

    @Override
    @NotNull
    public String getExecChainHandlerName() {
        return "REDIRECT_INTERCEPTOR";
    }
}

