/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.auth;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.webpdf.wsclient.exception.AuthResultException;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.AuthLoginOptions;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.auth.AuthProvider;
import net.webpdf.wsclient.session.auth.material.AuthMaterial;
import net.webpdf.wsclient.session.auth.material.token.SessionToken;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.connection.http.HttpRestRequest;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAuthenticationProvider
implements AuthProvider {
    @NotNull
    private static final String LOGIN_PATH = "authentication/user/login/";
    @NotNull
    private static final String REFRESH_PATH = "authentication/user/refresh/";
    @NotNull
    private final AuthMaterial initialAuthMaterial;
    @NotNull
    private final AtomicReference<AuthMaterial> authMaterial = new AtomicReference();
    @NotNull
    private final AtomicBoolean updating = new AtomicBoolean(false);
    @NotNull
    private final AtomicReference<Session> session = new AtomicReference();

    public AbstractAuthenticationProvider(@NotNull AuthMaterial authMaterial) {
        this.initialAuthMaterial = authMaterial;
        this.setAuthMaterial(authMaterial);
    }

    @Nullable
    public Session getSession() {
        return this.session.get();
    }

    @NotNull
    public AuthMaterial getInitialAuthMaterial() {
        return this.initialAuthMaterial;
    }

    @NotNull
    protected AuthMaterial getAuthMaterial() {
        return this.authMaterial.get();
    }

    protected void setAuthMaterial(@NotNull AuthMaterial authMaterial) {
        this.authMaterial.set(authMaterial);
    }

    @Override
    @NotNull
    public synchronized AuthMaterial provide(@NotNull Session session) throws AuthResultException {
        try {
            if (!this.updating.get() && session instanceof RestSession) {
                this.updating.set(true);
                RestSession restSession = (RestSession)session;
                if (this.session.get() == null || !session.equals(this.session.get()) || !(this.getAuthMaterial() instanceof SessionToken)) {
                    this.session.set(session);
                    AuthMaterial authMaterial = HttpRestRequest.createRequest(restSession).buildRequest(HttpMethod.POST, LOGIN_PATH, null, this.getInitialAuthMaterial()).executeRequest(SessionToken.class);
                    if (authMaterial == null) {
                        throw new ClientResultException(Error.AUTHENTICATION_FAILURE);
                    }
                    this.setAuthMaterial(authMaterial);
                }
                if (this.getAuthMaterial() instanceof SessionToken && ((SessionToken)this.getAuthMaterial()).isExpired(session.getSessionContext().getSkewTime())) {
                    AuthLoginOptions loginOptions = new AuthLoginOptions();
                    loginOptions.setCreateRefreshToken(true);
                    StringEntity entity = new StringEntity(SerializeHelper.toJSON(loginOptions), ContentType.create((String)DataFormat.JSON.getMimeType(), (Charset)StandardCharsets.UTF_8));
                    ((SessionToken)this.getAuthMaterial()).refresh();
                    AuthMaterial authMaterial = HttpRestRequest.createRequest(restSession).buildRequest(HttpMethod.POST, REFRESH_PATH, (HttpEntity)entity).executeRequest(SessionToken.class);
                    if (authMaterial == null) {
                        throw new ClientResultException(Error.SESSION_REFRESH_FAILURE);
                    }
                    this.setAuthMaterial(authMaterial);
                }
                this.updating.set(false);
            }
        }
        catch (ResultException ex) {
            throw new AuthResultException(ex);
        }
        return this.getAuthMaterial();
    }
}

