/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.auth.AuthProvider;
import net.webpdf.wsclient.session.auth.material.AuthMaterial;
import net.webpdf.wsclient.session.connection.SessionContext;
import net.webpdf.wsclient.session.connection.SessionContextSettings;
import net.webpdf.wsclient.webservice.WebServiceProtocol;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSession
implements Session {
    @NotNull
    private final WebServiceProtocol webServiceProtocol;
    @NotNull
    private final SessionContextSettings serverContext;
    @NotNull
    private final AuthProvider authProvider;
    @NotNull
    private final String basePath;
    @NotNull
    private final URI baseUrl;

    public AbstractSession(@NotNull WebServiceProtocol webServiceProtocol, @NotNull SessionContext serverContext, @NotNull AuthProvider authProvider) throws ResultException {
        this.serverContext = new SessionContextSettings(serverContext);
        this.authProvider = authProvider;
        this.webServiceProtocol = webServiceProtocol;
        this.basePath = webServiceProtocol.equals((Object)WebServiceProtocol.SOAP) ? "soap/" : "rest/";
        Object toUrl = this.serverContext.getUrl().toString();
        if (!((String)toUrl).endsWith("/")) {
            toUrl = (String)toUrl + "/";
        }
        try {
            URIBuilder uriBuilder = new URIBuilder((String)toUrl);
            this.baseUrl = uriBuilder.setUserInfo(null).build();
        }
        catch (URISyntaxException ex) {
            throw new ClientResultException(Error.INVALID_URL, ex);
        }
    }

    @Override
    @NotNull
    public synchronized AuthMaterial getAuthMaterial() throws ResultException {
        return this.authProvider.provide(this);
    }

    @Override
    @NotNull
    public WebServiceProtocol getWebServiceProtocol() {
        return this.webServiceProtocol;
    }

    @Override
    @NotNull
    public SessionContextSettings getSessionContext() {
        return this.serverContext;
    }

    @Override
    @NotNull
    public URI getURI(@NotNull String subPath) throws ResultException {
        try {
            return new URIBuilder(this.baseUrl).setPath(this.baseUrl.getPath() + this.basePath + subPath).build();
        }
        catch (URISyntaxException ex) {
            throw new ClientResultException(Error.INVALID_URL, ex);
        }
    }

    @Override
    @NotNull
    public URI getURI(@NotNull String subPath, List<NameValuePair> parameters) throws ResultException {
        try {
            return new URIBuilder(this.baseUrl).setPath(this.baseUrl.getPath() + this.basePath + subPath).addParameters(parameters).build();
        }
        catch (URISyntaxException ex) {
            throw new ClientResultException(Error.INVALID_URL, ex);
        }
    }
}

