/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.WebserviceResultStackTrace;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the result of the execution of a web service operation. The result contains in `code` the value zero if the execution was successful or a negative number as error code if an error occurred.  In case of an error code, `description` contains a description of the error and `stackTrace` contains the Java stack trace if an exception occurred.")
@JsonPropertyOrder(value={"code", "description", "exitCode", "stackTrace"})
@JsonTypeName(value="Webservice_Result")
public class WebserviceResult {
    public static final String JSON_PROPERTY_CODE = "code";
    private Integer code = 0;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description = "";
    public static final String JSON_PROPERTY_EXIT_CODE = "exitCode";
    private Integer exitCode = 0;
    public static final String JSON_PROPERTY_STACK_TRACE = "stackTrace";
    private WebserviceResultStackTrace stackTrace;

    public WebserviceResult code(Integer code) {
        this.code = code;
        return this;
    }

    @Schema(name="The error code of the operation. For a successful operation, this value must be zero. If you get any other negative value, the execution has failed.")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCode(Integer code) {
        this.code = code;
    }

    public WebserviceResult description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="A description of the operation\u00b4s result.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public WebserviceResult exitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @Schema(name="The exit code of an external application, if such an application was used for the operation.")
    @JsonProperty(value="exitCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getExitCode() {
        return this.exitCode;
    }

    @JsonProperty(value="exitCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public WebserviceResult stackTrace(WebserviceResultStackTrace stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="stackTrace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WebserviceResultStackTrace getStackTrace() {
        return this.stackTrace;
    }

    @JsonProperty(value="stackTrace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStackTrace(WebserviceResultStackTrace stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebserviceResult webserviceResult = (WebserviceResult)o;
        return Objects.equals(this.code, webserviceResult.code) && Objects.equals(this.description, webserviceResult.description) && Objects.equals(this.exitCode, webserviceResult.exitCode) && Objects.equals(this.stackTrace, webserviceResult.stackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.description, this.exitCode, this.stackTrace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebserviceResult {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    stackTrace: ").append(this.toIndentedString(this.stackTrace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

