/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigUserCertificateLdap;
import net.webpdf.wsclient.openapi.ServerConfigUserPKCS12;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines an LDAP dictionary or Active Directory as user source.")
@JsonPropertyOrder(value={"certificatesTrustMode", "connectionName", "connectionPassword", "connectionURL", "followReferral", "roleBase", "roleField", "roleSearch", "userBase", "userCertificates", "userPKCS12", "userSearch"})
@JsonTypeName(value="ServerConfig_UserLdap")
public class ServerConfigUserLdap {
    public static final String JSON_PROPERTY_CERTIFICATES_TRUST_MODE = "certificatesTrustMode";
    private CertificatesTrustModeEnum certificatesTrustMode = CertificatesTrustModeEnum.VALIDATE;
    public static final String JSON_PROPERTY_CONNECTION_NAME = "connectionName";
    private String connectionName = "";
    public static final String JSON_PROPERTY_CONNECTION_PASSWORD = "connectionPassword";
    private String connectionPassword = "";
    public static final String JSON_PROPERTY_CONNECTION_U_R_L = "connectionURL";
    private String connectionURL = "";
    public static final String JSON_PROPERTY_FOLLOW_REFERRAL = "followReferral";
    private Boolean followReferral = false;
    public static final String JSON_PROPERTY_ROLE_BASE = "roleBase";
    private String roleBase = "";
    public static final String JSON_PROPERTY_ROLE_FIELD = "roleField";
    private String roleField = "";
    public static final String JSON_PROPERTY_ROLE_SEARCH = "roleSearch";
    private String roleSearch = "";
    public static final String JSON_PROPERTY_USER_BASE = "userBase";
    private String userBase = "";
    public static final String JSON_PROPERTY_USER_CERTIFICATES = "userCertificates";
    private ServerConfigUserCertificateLdap userCertificates;
    public static final String JSON_PROPERTY_USER_P_K_C_S12 = "userPKCS12";
    private ServerConfigUserPKCS12 userPKCS12;
    public static final String JSON_PROPERTY_USER_SEARCH = "userSearch";
    private String userSearch = "";

    public ServerConfigUserLdap certificatesTrustMode(CertificatesTrustModeEnum certificatesTrustMode) {
        this.certificatesTrustMode = certificatesTrustMode;
        return this;
    }

    @Schema(name="Specifies the mode of handling the certificates presented by the LDAP server during connection establishment.  *   validate = Only certificates that can be verified as publicly valid are classified as trusted. It may be necessary to place the certificate or the issuer's certificate in the server's truststore. Self-signed certificates (e.g. from an own certificate authority) are excluded if they cannot be verified via a configured truststore. *   acceptAll = All certificates are classified as trusted, including expired, unverifiable, invalid or self-signed certificates.")
    @JsonProperty(value="certificatesTrustMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CertificatesTrustModeEnum getCertificatesTrustMode() {
        return this.certificatesTrustMode;
    }

    @JsonProperty(value="certificatesTrustMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertificatesTrustMode(CertificatesTrustModeEnum certificatesTrustMode) {
        this.certificatesTrustMode = certificatesTrustMode;
    }

    public ServerConfigUserLdap connectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    @Schema(name="The name of the user used to access the LDAP server. (e.g. \"cn=ldapuser,cn=Users,dc=example,dc=local\".)")
    @JsonProperty(value="connectionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConnectionName() {
        return this.connectionName;
    }

    @JsonProperty(value="connectionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public ServerConfigUserLdap connectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    @Schema(name="The password used to access the LDAP server.")
    @JsonProperty(value="connectionPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    @JsonProperty(value="connectionPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public ServerConfigUserLdap connectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
        return this;
    }

    @Schema(name="The URL used to connect to the LDAP server. (e.g. \"ldap://server.example.com:389/\".)")
    @JsonProperty(value="connectionURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConnectionURL() {
        return this.connectionURL;
    }

    @JsonProperty(value="connectionURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public ServerConfigUserLdap followReferral(Boolean followReferral) {
        this.followReferral = followReferral;
        return this;
    }

    @Schema(name="When set to true, all LDAP requests that respond with references are followed. The same schema and credentials are used for the referred request.")
    @JsonProperty(value="followReferral")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFollowReferral() {
        return this.followReferral;
    }

    @JsonProperty(value="followReferral")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowReferral(Boolean followReferral) {
        this.followReferral = followReferral;
    }

    public ServerConfigUserLdap roleBase(String roleBase) {
        this.roleBase = roleBase;
        return this;
    }

    @Schema(name="The Base for the LDAP user's role determination. (e.g. \"CN=Users,DC=example,DC=local\".)")
    @JsonProperty(value="roleBase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRoleBase() {
        return this.roleBase;
    }

    @JsonProperty(value="roleBase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleBase(String roleBase) {
        this.roleBase = roleBase;
    }

    public ServerConfigUserLdap roleField(String roleField) {
        this.roleField = roleField;
        return this;
    }

    @Schema(name="The field indicating, that a user is part of a group. (e.g. \"cn\".)")
    @JsonProperty(value="roleField")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRoleField() {
        return this.roleField;
    }

    @JsonProperty(value="roleField")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleField(String roleField) {
        this.roleField = roleField;
    }

    public ServerConfigUserLdap roleSearch(String roleSearch) {
        this.roleSearch = roleSearch;
        return this;
    }

    @Schema(name="The LDAP request used to find the user's role with. (e.g. \"(member={0})\".)")
    @JsonProperty(value="roleSearch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRoleSearch() {
        return this.roleSearch;
    }

    @JsonProperty(value="roleSearch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleSearch(String roleSearch) {
        this.roleSearch = roleSearch;
    }

    public ServerConfigUserLdap userBase(String userBase) {
        this.userBase = userBase;
        return this;
    }

    @Schema(name="The Base for the LDAP user search. (e.g. \"CN=Users,DC=example,DC=local\".)")
    @JsonProperty(value="userBase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserBase() {
        return this.userBase;
    }

    @JsonProperty(value="userBase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public ServerConfigUserLdap userCertificates(ServerConfigUserCertificateLdap userCertificates) {
        this.userCertificates = userCertificates;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="userCertificates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigUserCertificateLdap getUserCertificates() {
        return this.userCertificates;
    }

    @JsonProperty(value="userCertificates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserCertificates(ServerConfigUserCertificateLdap userCertificates) {
        this.userCertificates = userCertificates;
    }

    public ServerConfigUserLdap userPKCS12(ServerConfigUserPKCS12 userPKCS12) {
        this.userPKCS12 = userPKCS12;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="userPKCS12")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigUserPKCS12 getUserPKCS12() {
        return this.userPKCS12;
    }

    @JsonProperty(value="userPKCS12")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserPKCS12(ServerConfigUserPKCS12 userPKCS12) {
        this.userPKCS12 = userPKCS12;
    }

    public ServerConfigUserLdap userSearch(String userSearch) {
        this.userSearch = userSearch;
        return this;
    }

    @Schema(name="The LDAP request used to find the user's login name with. (e.g. \"(sAMAccountName={0})\".)")
    @JsonProperty(value="userSearch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserSearch() {
        return this.userSearch;
    }

    @JsonProperty(value="userSearch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSearch(String userSearch) {
        this.userSearch = userSearch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigUserLdap serverConfigUserLdap = (ServerConfigUserLdap)o;
        return Objects.equals((Object)this.certificatesTrustMode, (Object)serverConfigUserLdap.certificatesTrustMode) && Objects.equals(this.connectionName, serverConfigUserLdap.connectionName) && Objects.equals(this.connectionPassword, serverConfigUserLdap.connectionPassword) && Objects.equals(this.connectionURL, serverConfigUserLdap.connectionURL) && Objects.equals(this.followReferral, serverConfigUserLdap.followReferral) && Objects.equals(this.roleBase, serverConfigUserLdap.roleBase) && Objects.equals(this.roleField, serverConfigUserLdap.roleField) && Objects.equals(this.roleSearch, serverConfigUserLdap.roleSearch) && Objects.equals(this.userBase, serverConfigUserLdap.userBase) && Objects.equals(this.userCertificates, serverConfigUserLdap.userCertificates) && Objects.equals(this.userPKCS12, serverConfigUserLdap.userPKCS12) && Objects.equals(this.userSearch, serverConfigUserLdap.userSearch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.certificatesTrustMode, this.connectionName, this.connectionPassword, this.connectionURL, this.followReferral, this.roleBase, this.roleField, this.roleSearch, this.userBase, this.userCertificates, this.userPKCS12, this.userSearch});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigUserLdap {\n");
        sb.append("    certificatesTrustMode: ").append(this.toIndentedString((Object)this.certificatesTrustMode)).append("\n");
        sb.append("    connectionName: ").append(this.toIndentedString(this.connectionName)).append("\n");
        sb.append("    connectionPassword: ").append(this.toIndentedString(this.connectionPassword)).append("\n");
        sb.append("    connectionURL: ").append(this.toIndentedString(this.connectionURL)).append("\n");
        sb.append("    followReferral: ").append(this.toIndentedString(this.followReferral)).append("\n");
        sb.append("    roleBase: ").append(this.toIndentedString(this.roleBase)).append("\n");
        sb.append("    roleField: ").append(this.toIndentedString(this.roleField)).append("\n");
        sb.append("    roleSearch: ").append(this.toIndentedString(this.roleSearch)).append("\n");
        sb.append("    userBase: ").append(this.toIndentedString(this.userBase)).append("\n");
        sb.append("    userCertificates: ").append(this.toIndentedString(this.userCertificates)).append("\n");
        sb.append("    userPKCS12: ").append(this.toIndentedString(this.userPKCS12)).append("\n");
        sb.append("    userSearch: ").append(this.toIndentedString(this.userSearch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CertificatesTrustModeEnum {
        VALIDATE("validate"),
        ACCEPTALL("acceptAll");

        private String value;

        private CertificatesTrustModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CertificatesTrustModeEnum fromValue(String value) {
            for (CertificatesTrustModeEnum b : CertificatesTrustModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

