/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigSessionAccessToken;
import net.webpdf.wsclient.openapi.ServerConfigSessionLimits;
import net.webpdf.wsclient.openapi.ServerConfigSessionRefreshToken;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the settings for accessing the server's REST API (web services).")
@JsonPropertyOrder(value={"accessToken", "allowAnonymous", "enabled", "limits", "maxTimeSkew", "refreshToken"})
@JsonTypeName(value="ServerConfig_LocalAuthRest")
public class ServerConfigLocalAuthRest {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "accessToken";
    private ServerConfigSessionAccessToken accessToken;
    public static final String JSON_PROPERTY_ALLOW_ANONYMOUS = "allowAnonymous";
    private Boolean allowAnonymous = true;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_LIMITS = "limits";
    private ServerConfigSessionLimits limits;
    public static final String JSON_PROPERTY_MAX_TIME_SKEW = "maxTimeSkew";
    private Integer maxTimeSkew = 0;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refreshToken";
    private ServerConfigSessionRefreshToken refreshToken;

    public ServerConfigLocalAuthRest accessToken(ServerConfigSessionAccessToken accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="accessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigSessionAccessToken getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="accessToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessToken(ServerConfigSessionAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public ServerConfigLocalAuthRest allowAnonymous(Boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
        return this;
    }

    @Schema(name="If enabled, then anonymous logins (without username and password) are allowed.")
    @JsonProperty(value="allowAnonymous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAllowAnonymous() {
        return this.allowAnonymous;
    }

    @JsonProperty(value="allowAnonymous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowAnonymous(Boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    public ServerConfigLocalAuthRest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If enabled, then the REST API is available.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ServerConfigLocalAuthRest limits(ServerConfigSessionLimits limits) {
        this.limits = limits;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigSessionLimits getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimits(ServerConfigSessionLimits limits) {
        this.limits = limits;
    }

    public ServerConfigLocalAuthRest maxTimeSkew(Integer maxTimeSkew) {
        this.maxTimeSkew = maxTimeSkew;
        return this;
    }

    @Schema(name="The maximum time skew that may occur between the local time of the client and the local time of the token issuer (the local server).")
    @JsonProperty(value="maxTimeSkew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxTimeSkew() {
        return this.maxTimeSkew;
    }

    @JsonProperty(value="maxTimeSkew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxTimeSkew(Integer maxTimeSkew) {
        this.maxTimeSkew = maxTimeSkew;
    }

    public ServerConfigLocalAuthRest refreshToken(ServerConfigSessionRefreshToken refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigSessionRefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refreshToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(ServerConfigSessionRefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigLocalAuthRest serverConfigLocalAuthRest = (ServerConfigLocalAuthRest)o;
        return Objects.equals(this.accessToken, serverConfigLocalAuthRest.accessToken) && Objects.equals(this.allowAnonymous, serverConfigLocalAuthRest.allowAnonymous) && Objects.equals(this.enabled, serverConfigLocalAuthRest.enabled) && Objects.equals(this.limits, serverConfigLocalAuthRest.limits) && Objects.equals(this.maxTimeSkew, serverConfigLocalAuthRest.maxTimeSkew) && Objects.equals(this.refreshToken, serverConfigLocalAuthRest.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.allowAnonymous, this.enabled, this.limits, this.maxTimeSkew, this.refreshToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigLocalAuthRest {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    allowAnonymous: ").append(this.toIndentedString(this.allowAnonymous)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    maxTimeSkew: ").append(this.toIndentedString(this.maxTimeSkew)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

