/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationAnnotationSelection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="When activated, the goTo3DView action will jump to a specific view of a 3D object (a 3D annotation).")
@JsonPropertyOrder(value={"annotation", "index", "name", "relative"})
@JsonTypeName(value="Operation_GoTo3DViewAction_goTo3DView")
public class OperationGoTo3DViewActionGoTo3DView {
    public static final String JSON_PROPERTY_ANNOTATION = "annotation";
    private OperationAnnotationSelection annotation;
    public static final String JSON_PROPERTY_INDEX = "index";
    private Integer index = 0;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_RELATIVE = "relative";
    private RelativeEnum relative = RelativeEnum.DEFAULT;

    public OperationGoTo3DViewActionGoTo3DView annotation(OperationAnnotationSelection annotation) {
        this.annotation = annotation;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="annotation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationAnnotationSelection getAnnotation() {
        return this.annotation;
    }

    @JsonProperty(value="annotation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAnnotation(OperationAnnotationSelection annotation) {
        this.annotation = annotation;
    }

    public OperationGoTo3DViewActionGoTo3DView index(Integer index) {
        this.index = index;
        return this;
    }

    @Schema(name="The index for the 3D annotation view. This value is an alternative to \"name\" and \"relative\" and does not have to be set if either one of these values are specified.")
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndex(Integer index) {
        this.index = index;
    }

    public OperationGoTo3DViewActionGoTo3DView name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The name of the 3D annotation view. This value is an alternative to \"index\" and \"relative\" and does not have to be set if either one of these values are specified.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationGoTo3DViewActionGoTo3DView relative(RelativeEnum relative) {
        this.relative = relative;
        return this;
    }

    @Schema(name="A view of the 3D annotation that has been defined relative to the currently visualized view. This value is an alternative to \"name\" and \"index\" and does not have to be set if either one of these values are specified.  *   First = The first view of the 3D annotation. *   Last = The last view of the 3D annotation. *   Next = The next view of the 3D annotation. *   Previous = The previous view of the 3D annotation. *   Default = The default view of the 3D annotation.")
    @JsonProperty(value="relative")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public RelativeEnum getRelative() {
        return this.relative;
    }

    @JsonProperty(value="relative")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelative(RelativeEnum relative) {
        this.relative = relative;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationGoTo3DViewActionGoTo3DView operationGoTo3DViewActionGoTo3DView = (OperationGoTo3DViewActionGoTo3DView)o;
        return Objects.equals(this.annotation, operationGoTo3DViewActionGoTo3DView.annotation) && Objects.equals(this.index, operationGoTo3DViewActionGoTo3DView.index) && Objects.equals(this.name, operationGoTo3DViewActionGoTo3DView.name) && Objects.equals((Object)this.relative, (Object)operationGoTo3DViewActionGoTo3DView.relative);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotation, this.index, this.name, this.relative});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationGoTo3DViewActionGoTo3DView {\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relative: ").append(this.toIndentedString((Object)this.relative)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RelativeEnum {
        FIRST("First"),
        LAST("Last"),
        NEXT("Next"),
        PREVIOUS("Previous"),
        DEFAULT("Default");

        private String value;

        private RelativeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RelativeEnum fromValue(String value) {
            for (RelativeEnum b : RelativeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

