/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="An EAN8 barcode.")
@JsonPropertyOrder(value={"charset", "margin", "pages", "position", "rotation", "value"})
@JsonTypeName(value="Operation_Ean8Barcode")
public class OperationEan8Barcode {
    public static final String JSON_PROPERTY_CHARSET = "charset";
    private String charset = "utf-8";
    public static final String JSON_PROPERTY_MARGIN = "margin";
    private Integer margin = 0;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationRectangle position;
    public static final String JSON_PROPERTY_ROTATION = "rotation";
    private Integer rotation = 0;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public OperationEan8Barcode charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Schema(name="Used to specify the character set in which the barcode contents should be stored.")
    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public OperationEan8Barcode margin(Integer margin) {
        this.margin = margin;
        return this;
    }

    @Schema(name="Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.")
    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMargin() {
        return this.margin;
    }

    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMargin(Integer margin) {
        this.margin = margin;
    }

    public OperationEan8Barcode pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationEan8Barcode position(OperationRectangle position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationRectangle getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationRectangle position) {
        this.position = position;
    }

    public OperationEan8Barcode rotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    @Schema(name="Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.")
    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public OperationEan8Barcode value(String value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, name="Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \"Barcodes\"")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationEan8Barcode operationEan8Barcode = (OperationEan8Barcode)o;
        return Objects.equals(this.charset, operationEan8Barcode.charset) && Objects.equals(this.margin, operationEan8Barcode.margin) && Objects.equals(this.pages, operationEan8Barcode.pages) && Objects.equals(this.position, operationEan8Barcode.position) && Objects.equals(this.rotation, operationEan8Barcode.rotation) && Objects.equals(this.value, operationEan8Barcode.value);
    }

    public int hashCode() {
        return Objects.hash(this.charset, this.margin, this.pages, this.position, this.rotation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationEan8Barcode {\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

