/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="These settings are only used for e-mail documents. The \"MIME\" (eml; RFC-822) and Outlook (msg) e-mail formats are supported.")
@JsonPropertyOrder(value={"adjustFonts", "attachmentMode", "downloadImages", "ignoreMissingBodyChunk", "resizeImages", "resizeTables", "useBackground"})
@JsonTypeName(value="Operation_ConverterMail")
public class OperationConverterMail {
    public static final String JSON_PROPERTY_ADJUST_FONTS = "adjustFonts";
    private Boolean adjustFonts = false;
    public static final String JSON_PROPERTY_ATTACHMENT_MODE = "attachmentMode";
    private AttachmentModeEnum attachmentMode = AttachmentModeEnum.EMBED;
    public static final String JSON_PROPERTY_DOWNLOAD_IMAGES = "downloadImages";
    private Boolean downloadImages = false;
    public static final String JSON_PROPERTY_IGNORE_MISSING_BODY_CHUNK = "ignoreMissingBodyChunk";
    private Boolean ignoreMissingBodyChunk = false;
    public static final String JSON_PROPERTY_RESIZE_IMAGES = "resizeImages";
    private Boolean resizeImages = false;
    public static final String JSON_PROPERTY_RESIZE_TABLES = "resizeTables";
    private Boolean resizeTables = false;
    public static final String JSON_PROPERTY_USE_BACKGROUND = "useBackground";
    private Boolean useBackground = true;

    public OperationConverterMail adjustFonts(Boolean adjustFonts) {
        this.adjustFonts = adjustFonts;
        return this;
    }

    @Schema(name="If \"true\", then the font specifications \"Arial\", \"Helvetica\" and \"Sans-Serif\" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \"Arial Unicode MS\" font. The improves the appearance of the typeface in the PDF result.")
    @JsonProperty(value="adjustFonts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAdjustFonts() {
        return this.adjustFonts;
    }

    @JsonProperty(value="adjustFonts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdjustFonts(Boolean adjustFonts) {
        this.adjustFonts = adjustFonts;
    }

    public OperationConverterMail attachmentMode(AttachmentModeEnum attachmentMode) {
        this.attachmentMode = attachmentMode;
        return this;
    }

    @Schema(name="Specifies the manner in which attachments are to be processed in e-mails.  *   embed = Embed in original format *   remove = Remove attachments *   convert = Converts the attachments to PDF format and embeds them as an attachment *   convertMerge = Converts the attachments to PDF format and appends them as additional page(s) at the end  **Important:** If conversion to PDF format is not possible when using \"convert\" or \"convertMerge\", the attachment will be embedded in its original format.")
    @JsonProperty(value="attachmentMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AttachmentModeEnum getAttachmentMode() {
        return this.attachmentMode;
    }

    @JsonProperty(value="attachmentMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachmentMode(AttachmentModeEnum attachmentMode) {
        this.attachmentMode = attachmentMode;
    }

    public OperationConverterMail downloadImages(Boolean downloadImages) {
        this.downloadImages = downloadImages;
        return this;
    }

    @Schema(name="If \"true\", then the images of an e-mail or an HTML document are downloaded automatically. This option could slow down the conversion considerably if there are many images contained or if, for example, e-mail documents are converted in which the images can no longer be invoked.")
    @JsonProperty(value="downloadImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDownloadImages() {
        return this.downloadImages;
    }

    @JsonProperty(value="downloadImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownloadImages(Boolean downloadImages) {
        this.downloadImages = downloadImages;
    }

    public OperationConverterMail ignoreMissingBodyChunk(Boolean ignoreMissingBodyChunk) {
        this.ignoreMissingBodyChunk = ignoreMissingBodyChunk;
        return this;
    }

    @Schema(name="If this option is enabled, an error will not be triggered (the conversion will not be aborted) for e-mails if there is no body element in the file structure. However, this should not be confused with an e-mail not having any content.")
    @JsonProperty(value="ignoreMissingBodyChunk")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIgnoreMissingBodyChunk() {
        return this.ignoreMissingBodyChunk;
    }

    @JsonProperty(value="ignoreMissingBodyChunk")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIgnoreMissingBodyChunk(Boolean ignoreMissingBodyChunk) {
        this.ignoreMissingBodyChunk = ignoreMissingBodyChunk;
    }

    public OperationConverterMail resizeImages(Boolean resizeImages) {
        this.resizeImages = resizeImages;
        return this;
    }

    @Schema(name="If true, then an attempt is made to fit all images that are not in a table to the maximum page width in the PDF document. The graphics will be scaled (while maintaining the aspect ratio) to fit the width of the page and not be cut off. Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to the scaling.  **Important:** If the \"resizeImages\" option is enabled, you must expect that the original appearance of the e-mail document will no longer be preserved.")
    @JsonProperty(value="resizeImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getResizeImages() {
        return this.resizeImages;
    }

    @JsonProperty(value="resizeImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResizeImages(Boolean resizeImages) {
        this.resizeImages = resizeImages;
    }

    public OperationConverterMail resizeTables(Boolean resizeTables) {
        this.resizeTables = resizeTables;
        return this;
    }

    @Schema(name="If true, then an attempt is made to fit all tables to the maximum page width in the PDF document. An attempt is made to reduce the individual columns of a table so that the table fits completely within the page width. This works only for simple tables originally defined with dynamic sizes and not for nested tables (table-in-table). Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to scaling.  **Important:** If the option \"resizeTables\" is activated, you must expect that the original appearance of the e-mail document is no longer preserved. The recalculation of the table columns may also result in very narrow columns in the output.")
    @JsonProperty(value="resizeTables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getResizeTables() {
        return this.resizeTables;
    }

    @JsonProperty(value="resizeTables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResizeTables(Boolean resizeTables) {
        this.resizeTables = resizeTables;
    }

    public OperationConverterMail useBackground(Boolean useBackground) {
        this.useBackground = useBackground;
        return this;
    }

    @Schema(name="If \"true\", then a background defined in the e-mail (in the HTML content) is also output in the PDF document. If \"false\", the background will be hidden.")
    @JsonProperty(value="useBackground")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseBackground() {
        return this.useBackground;
    }

    @JsonProperty(value="useBackground")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseBackground(Boolean useBackground) {
        this.useBackground = useBackground;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterMail operationConverterMail = (OperationConverterMail)o;
        return Objects.equals(this.adjustFonts, operationConverterMail.adjustFonts) && Objects.equals((Object)this.attachmentMode, (Object)operationConverterMail.attachmentMode) && Objects.equals(this.downloadImages, operationConverterMail.downloadImages) && Objects.equals(this.ignoreMissingBodyChunk, operationConverterMail.ignoreMissingBodyChunk) && Objects.equals(this.resizeImages, operationConverterMail.resizeImages) && Objects.equals(this.resizeTables, operationConverterMail.resizeTables) && Objects.equals(this.useBackground, operationConverterMail.useBackground);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.adjustFonts, this.attachmentMode, this.downloadImages, this.ignoreMissingBodyChunk, this.resizeImages, this.resizeTables, this.useBackground});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterMail {\n");
        sb.append("    adjustFonts: ").append(this.toIndentedString(this.adjustFonts)).append("\n");
        sb.append("    attachmentMode: ").append(this.toIndentedString((Object)this.attachmentMode)).append("\n");
        sb.append("    downloadImages: ").append(this.toIndentedString(this.downloadImages)).append("\n");
        sb.append("    ignoreMissingBodyChunk: ").append(this.toIndentedString(this.ignoreMissingBodyChunk)).append("\n");
        sb.append("    resizeImages: ").append(this.toIndentedString(this.resizeImages)).append("\n");
        sb.append("    resizeTables: ").append(this.toIndentedString(this.resizeTables)).append("\n");
        sb.append("    useBackground: ").append(this.toIndentedString(this.useBackground)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AttachmentModeEnum {
        EMBED("embed"),
        REMOVE("remove"),
        CONVERT("convert"),
        CONVERTMERGE("convertMerge"),
        CONVERTEMBED("convertEmbed"),
        CONVERTMERGEEMBED("convertMergeEmbed");

        private String value;

        private AttachmentModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AttachmentModeEnum fromValue(String value) {
            for (AttachmentModeEnum b : AttachmentModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

