/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The `billing` element can be used to affect the values that are written to the server's statistics logs (called \"billing logs\") for the web service call.")
@JsonPropertyOrder(value={"applicationName", "customerCode", "userName"})
@JsonTypeName(value="Operation_Billing")
public class OperationBilling {
    public static final String JSON_PROPERTY_APPLICATION_NAME = "applicationName";
    private String applicationName = "external";
    public static final String JSON_PROPERTY_CUSTOMER_CODE = "customerCode";
    private String customerCode = "";
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName = "";

    public OperationBilling applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Schema(name="A free text that specifies the name of the application calling the web service. This attribute makes it possible to analyze the logs with regard to specific applications, for example.  **Important:** If the web service is called by an external application that does not set its own value for \"applicationName\", a value of \"external\" will be entered automatically. If the web service is called from the server's portal, a value of \"portal\" will be entered automatically.")
    @JsonProperty(value="applicationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @JsonProperty(value="applicationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public OperationBilling customerCode(String customerCode) {
        this.customerCode = customerCode;
        return this;
    }

    @Schema(name="A free text that identifies the customer calling the web service. This attribute makes it possible to analyze the logs with regard to specific customers, for example.")
    @JsonProperty(value="customerCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCustomerCode() {
        return this.customerCode;
    }

    @JsonProperty(value="customerCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public OperationBilling userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(name="A free text that specifies the name of the user calling the web service. This attribute makes it possible to analyze the logs with regard to specific users, for example.  **Important:** If the web service is called from the server's portal and a user is logged in, the user's name will be entered automatically.")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationBilling operationBilling = (OperationBilling)o;
        return Objects.equals(this.applicationName, operationBilling.applicationName) && Objects.equals(this.customerCode, operationBilling.customerCode) && Objects.equals(this.userName, operationBilling.userName);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.customerCode, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationBilling {\n");
        sb.append("    applicationName: ").append(this.toIndentedString(this.applicationName)).append("\n");
        sb.append("    customerCode: ").append(this.toIndentedString(this.customerCode)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

