/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationAppearanceFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define a svg resource for an annotation's appearance generation.")
@JsonPropertyOrder(value={"aspectRatioAxis", "data", "preserveAspectRatio"})
@JsonTypeName(value="Operation_AppearanceSvg")
public class OperationAppearanceSvg {
    public static final String JSON_PROPERTY_ASPECT_RATIO_AXIS = "aspectRatioAxis";
    private AspectRatioAxisEnum aspectRatioAxis = AspectRatioAxisEnum.X;
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationAppearanceFileData data;
    public static final String JSON_PROPERTY_PRESERVE_ASPECT_RATIO = "preserveAspectRatio";
    private Boolean preserveAspectRatio = false;

    public OperationAppearanceSvg aspectRatioAxis(AspectRatioAxisEnum aspectRatioAxis) {
        this.aspectRatioAxis = aspectRatioAxis;
        return this;
    }

    @Schema(name="Selects a predefined axis for a coordinate system.")
    @JsonProperty(value="aspectRatioAxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AspectRatioAxisEnum getAspectRatioAxis() {
        return this.aspectRatioAxis;
    }

    @JsonProperty(value="aspectRatioAxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAspectRatioAxis(AspectRatioAxisEnum aspectRatioAxis) {
        this.aspectRatioAxis = aspectRatioAxis;
    }

    public OperationAppearanceSvg data(OperationAppearanceFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationAppearanceFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationAppearanceFileData data) {
        this.data = data;
    }

    public OperationAppearanceSvg preserveAspectRatio(Boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
        return this;
    }

    @Schema(name="Specifies whether the aspect ratio should be maintained when scaling the annotation.")
    @JsonProperty(value="preserveAspectRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    @JsonProperty(value="preserveAspectRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreserveAspectRatio(Boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationAppearanceSvg operationAppearanceSvg = (OperationAppearanceSvg)o;
        return Objects.equals((Object)this.aspectRatioAxis, (Object)operationAppearanceSvg.aspectRatioAxis) && Objects.equals(this.data, operationAppearanceSvg.data) && Objects.equals(this.preserveAspectRatio, operationAppearanceSvg.preserveAspectRatio);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aspectRatioAxis, this.data, this.preserveAspectRatio});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationAppearanceSvg {\n");
        sb.append("    aspectRatioAxis: ").append(this.toIndentedString((Object)this.aspectRatioAxis)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    preserveAspectRatio: ").append(this.toIndentedString(this.preserveAspectRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AspectRatioAxisEnum {
        X("x"),
        Y("y");

        private String value;

        private AspectRatioAxisEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AspectRatioAxisEnum fromValue(String value) {
            for (AspectRatioAxisEnum b : AspectRatioAxisEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

