/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataBorderStyle;
import net.webpdf.wsclient.openapi.MetadataDrawStyle;
import net.webpdf.wsclient.openapi.MetadataLine;
import net.webpdf.wsclient.openapi.MetadataMarkup;
import net.webpdf.wsclient.openapi.MetadataPopup;
import net.webpdf.wsclient.openapi.MetadataPositions;
import org.jetbrains.annotations.Nullable;

@Schema(description="An element of this type describes an Annotation placed on a page of the document.")
@JsonPropertyOrder(value={"appearance", "border", "color", "contents", "drawStyle", "hidden", "iconName", "invisible", "line", "locked", "markup", "name", "objectKey", "page", "popup", "positions", "printable", "rotatable", "rotation", "subType", "viewable", "writable", "zoomable"})
@JsonTypeName(value="Metadata_Annotation")
public class MetadataAnnotation {
    public static final String JSON_PROPERTY_APPEARANCE = "appearance";
    private Object appearance;
    public static final String JSON_PROPERTY_BORDER = "border";
    private MetadataBorderStyle border;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#4800FF";
    public static final String JSON_PROPERTY_CONTENTS = "contents";
    private String contents = "";
    public static final String JSON_PROPERTY_DRAW_STYLE = "drawStyle";
    private MetadataDrawStyle drawStyle;
    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden = false;
    public static final String JSON_PROPERTY_ICON_NAME = "iconName";
    private String iconName = "";
    public static final String JSON_PROPERTY_INVISIBLE = "invisible";
    private Boolean invisible = false;
    public static final String JSON_PROPERTY_LINE = "line";
    private MetadataLine line;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked = true;
    public static final String JSON_PROPERTY_MARKUP = "markup";
    private MetadataMarkup markup;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_POPUP = "popup";
    private MetadataPopup popup;
    public static final String JSON_PROPERTY_POSITIONS = "positions";
    private List<MetadataPositions> positions = null;
    public static final String JSON_PROPERTY_PRINTABLE = "printable";
    private Boolean printable = false;
    public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
    private Boolean rotatable = true;
    public static final String JSON_PROPERTY_ROTATION = "rotation";
    private Integer rotation = 0;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private String subType = "";
    public static final String JSON_PROPERTY_VIEWABLE = "viewable";
    private Boolean viewable = true;
    public static final String JSON_PROPERTY_WRITABLE = "writable";
    private Boolean writable = true;
    public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
    private Boolean zoomable = true;

    public MetadataAnnotation appearance(Object appearance) {
        this.appearance = appearance;
        return this;
    }

    @Schema(name="Defines a set of attributes concerning the appearance of the annotation.")
    @JsonProperty(value="appearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Object getAppearance() {
        return this.appearance;
    }

    @JsonProperty(value="appearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppearance(Object appearance) {
        this.appearance = appearance;
    }

    public MetadataAnnotation border(MetadataBorderStyle border) {
        this.border = border;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataBorderStyle getBorder() {
        return this.border;
    }

    @JsonProperty(value="border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBorder(MetadataBorderStyle border) {
        this.border = border;
    }

    public MetadataAnnotation color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The main color of visible annotations. The color will be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public MetadataAnnotation contents(String contents) {
        this.contents = contents;
        return this;
    }

    @Schema(name="The annotation's textual contents or (should an annotation of this type not have such contents) it's description.")
    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContents(String contents) {
        this.contents = contents;
    }

    public MetadataAnnotation drawStyle(MetadataDrawStyle drawStyle) {
        this.drawStyle = drawStyle;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="drawStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataDrawStyle getDrawStyle() {
        return this.drawStyle;
    }

    @JsonProperty(value="drawStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDrawStyle(MetadataDrawStyle drawStyle) {
        this.drawStyle = drawStyle;
    }

    public MetadataAnnotation hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public MetadataAnnotation iconName(String iconName) {
        this.iconName = iconName;
        return this;
    }

    @Schema(name="If the annotation selects an icon (Text annotations), this is the name of that icon.")
    @JsonProperty(value="iconName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIconName() {
        return this.iconName;
    }

    @JsonProperty(value="iconName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public MetadataAnnotation invisible(Boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getInvisible() {
        return this.invisible;
    }

    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvisible(Boolean invisible) {
        this.invisible = invisible;
    }

    public MetadataAnnotation line(MetadataLine line) {
        this.line = line;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataLine getLine() {
        return this.line;
    }

    @JsonProperty(value="line")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLine(MetadataLine line) {
        this.line = line;
    }

    public MetadataAnnotation locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be locked so that no changes can be made to it.")
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public MetadataAnnotation markup(MetadataMarkup markup) {
        this.markup = markup;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="markup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataMarkup getMarkup() {
        return this.markup;
    }

    @JsonProperty(value="markup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkup(MetadataMarkup markup) {
        this.markup = markup;
    }

    public MetadataAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The annotation's name.  **Important:** This name is optional and in the best case unique in the annotation's page context only. Don't use the name to select an annotation, always prefer selecting objects by object ID, when possible.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MetadataAnnotation objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the annotation. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The number of the page the annotation is placed on.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MetadataAnnotation popup(MetadataPopup popup) {
        this.popup = popup;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="popup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataPopup getPopup() {
        return this.popup;
    }

    @JsonProperty(value="popup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPopup(MetadataPopup popup) {
        this.popup = popup;
    }

    public MetadataAnnotation positions(List<MetadataPositions> positions) {
        this.positions = positions;
        return this;
    }

    public MetadataAnnotation addPositionsItem(MetadataPositions positionsItem) {
        if (this.positions == null) {
            this.positions = new ArrayList<MetadataPositions>();
        }
        this.positions.add(positionsItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="positions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataPositions> getPositions() {
        return this.positions;
    }

    @JsonProperty(value="positions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPositions(List<MetadataPositions> positions) {
        this.positions = positions;
    }

    public MetadataAnnotation printable(Boolean printable) {
        this.printable = printable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be included when the page is printed out.")
    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPrintable() {
        return this.printable;
    }

    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintable(Boolean printable) {
        this.printable = printable;
    }

    public MetadataAnnotation rotatable(Boolean rotatable) {
        this.rotatable = rotatable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRotatable() {
        return this.rotatable;
    }

    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotatable(Boolean rotatable) {
        this.rotatable = rotatable;
    }

    public MetadataAnnotation rotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    @Schema(name="The annotation's rotation.")
    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public MetadataAnnotation subType(String subType) {
        this.subType = subType;
        return this;
    }

    @Schema(name="The type of an annotation is always \"Annot\", this is the sub type of the annotation determining the actual behavior and function of the annotation. (i.e. Text, Link, Widget etc.)")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubType(String subType) {
        this.subType = subType;
    }

    public MetadataAnnotation viewable(Boolean viewable) {
        this.viewable = viewable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be shown on the document's page.")
    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getViewable() {
        return this.viewable;
    }

    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewable(Boolean viewable) {
        this.viewable = viewable;
    }

    public MetadataAnnotation writable(Boolean writable) {
        this.writable = writable;
        return this;
    }

    @Schema(name="If this value is set to true, it will be possible to change the annotation's contents later on.")
    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getWritable() {
        return this.writable;
    }

    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWritable(Boolean writable) {
        this.writable = writable;
    }

    public MetadataAnnotation zoomable(Boolean zoomable) {
        this.zoomable = zoomable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getZoomable() {
        return this.zoomable;
    }

    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataAnnotation metadataAnnotation = (MetadataAnnotation)o;
        return Objects.equals(this.appearance, metadataAnnotation.appearance) && Objects.equals(this.border, metadataAnnotation.border) && Objects.equals(this.color, metadataAnnotation.color) && Objects.equals(this.contents, metadataAnnotation.contents) && Objects.equals(this.drawStyle, metadataAnnotation.drawStyle) && Objects.equals(this.hidden, metadataAnnotation.hidden) && Objects.equals(this.iconName, metadataAnnotation.iconName) && Objects.equals(this.invisible, metadataAnnotation.invisible) && Objects.equals(this.line, metadataAnnotation.line) && Objects.equals(this.locked, metadataAnnotation.locked) && Objects.equals(this.markup, metadataAnnotation.markup) && Objects.equals(this.name, metadataAnnotation.name) && Objects.equals(this.objectKey, metadataAnnotation.objectKey) && Objects.equals(this.page, metadataAnnotation.page) && Objects.equals(this.popup, metadataAnnotation.popup) && Objects.equals(this.positions, metadataAnnotation.positions) && Objects.equals(this.printable, metadataAnnotation.printable) && Objects.equals(this.rotatable, metadataAnnotation.rotatable) && Objects.equals(this.rotation, metadataAnnotation.rotation) && Objects.equals(this.subType, metadataAnnotation.subType) && Objects.equals(this.viewable, metadataAnnotation.viewable) && Objects.equals(this.writable, metadataAnnotation.writable) && Objects.equals(this.zoomable, metadataAnnotation.zoomable);
    }

    public int hashCode() {
        return Objects.hash(this.appearance, this.border, this.color, this.contents, this.drawStyle, this.hidden, this.iconName, this.invisible, this.line, this.locked, this.markup, this.name, this.objectKey, this.page, this.popup, this.positions, this.printable, this.rotatable, this.rotation, this.subType, this.viewable, this.writable, this.zoomable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataAnnotation {\n");
        sb.append("    appearance: ").append(this.toIndentedString(this.appearance)).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    drawStyle: ").append(this.toIndentedString(this.drawStyle)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    iconName: ").append(this.toIndentedString(this.iconName)).append("\n");
        sb.append("    invisible: ").append(this.toIndentedString(this.invisible)).append("\n");
        sb.append("    line: ").append(this.toIndentedString(this.line)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    markup: ").append(this.toIndentedString(this.markup)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    popup: ").append(this.toIndentedString(this.popup)).append("\n");
        sb.append("    positions: ").append(this.toIndentedString(this.positions)).append("\n");
        sb.append("    printable: ").append(this.toIndentedString(this.printable)).append("\n");
        sb.append("    rotatable: ").append(this.toIndentedString(this.rotatable)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString(this.subType)).append("\n");
        sb.append("    viewable: ").append(this.toIndentedString(this.viewable)).append("\n");
        sb.append("    writable: ").append(this.toIndentedString(this.writable)).append("\n");
        sb.append("    zoomable: ").append(this.toIndentedString(this.zoomable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

