/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides the server\u00b4s license and version information")
@JsonPropertyOrder(value={"licenseText", "mainVersion", "minorVersion", "serverStart", "serverVersion"})
@JsonTypeName(value="Admin_ServerVersionInfo")
public class AdminServerVersionInfo {
    public static final String JSON_PROPERTY_LICENSE_TEXT = "licenseText";
    private String licenseText = "";
    public static final String JSON_PROPERTY_MAIN_VERSION = "mainVersion";
    private Integer mainVersion = 0;
    public static final String JSON_PROPERTY_MINOR_VERSION = "minorVersion";
    private Integer minorVersion = 0;
    public static final String JSON_PROPERTY_SERVER_START = "serverStart";
    private Long serverStart = 0L;
    public static final String JSON_PROPERTY_SERVER_VERSION = "serverVersion";
    private String serverVersion = "";

    public AdminServerVersionInfo licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Schema(name="A string summarizing the server\u00b4s current license.")
    @JsonProperty(value="licenseText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLicenseText() {
        return this.licenseText;
    }

    @JsonProperty(value="licenseText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public AdminServerVersionInfo mainVersion(Integer mainVersion) {
        this.mainVersion = mainVersion;
        return this;
    }

    @Schema(name="The numeric major version of the server.")
    @JsonProperty(value="mainVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMainVersion() {
        return this.mainVersion;
    }

    @JsonProperty(value="mainVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMainVersion(Integer mainVersion) {
        this.mainVersion = mainVersion;
    }

    public AdminServerVersionInfo minorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    @Schema(name="The numeric minor version of the server.")
    @JsonProperty(value="minorVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    @JsonProperty(value="minorVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
    }

    public AdminServerVersionInfo serverStart(Long serverStart) {
        this.serverStart = serverStart;
        return this;
    }

    @Schema(name="The server start data and time (UTC) as Epoch Unix Timestamp")
    @JsonProperty(value="serverStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getServerStart() {
        return this.serverStart;
    }

    @JsonProperty(value="serverStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServerStart(Long serverStart) {
        this.serverStart = serverStart;
    }

    public AdminServerVersionInfo serverVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    @Schema(name="A formatted string containing the server\u00b4s name and version.")
    @JsonProperty(value="serverVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getServerVersion() {
        return this.serverVersion;
    }

    @JsonProperty(value="serverVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminServerVersionInfo adminServerVersionInfo = (AdminServerVersionInfo)o;
        return Objects.equals(this.licenseText, adminServerVersionInfo.licenseText) && Objects.equals(this.mainVersion, adminServerVersionInfo.mainVersion) && Objects.equals(this.minorVersion, adminServerVersionInfo.minorVersion) && Objects.equals(this.serverStart, adminServerVersionInfo.serverStart) && Objects.equals(this.serverVersion, adminServerVersionInfo.serverVersion);
    }

    public int hashCode() {
        return Objects.hash(this.licenseText, this.mainVersion, this.minorVersion, this.serverStart, this.serverVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminServerVersionInfo {\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    mainVersion: ").append(this.toIndentedString(this.mainVersion)).append("\n");
        sb.append("    minorVersion: ").append(this.toIndentedString(this.minorVersion)).append("\n");
        sb.append("    serverStart: ").append(this.toIndentedString(this.serverStart)).append("\n");
        sb.append("    serverVersion: ").append(this.toIndentedString(this.serverVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

