/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AdminApplicationConfiguration;
import net.webpdf.wsclient.openapi.AdminConfiguration;
import net.webpdf.wsclient.openapi.AdminConnectorKeyStore;
import net.webpdf.wsclient.openapi.AdminLogConfiguration;
import net.webpdf.wsclient.openapi.AdminServerCheck;
import net.webpdf.wsclient.openapi.AdminTrustStoreKeyStore;
import net.webpdf.wsclient.openapi.AdminUserConfiguration;
import net.webpdf.wsclient.openapi.ServerConfigServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines settings for the server\u00b4s \"server.xml\". And provides the means (checks) to validate the server configuration and resources.")
@JsonPropertyOrder(value={"configuration", "configurationChecks", "connectorKeyStore", "trustStoreKeyStore"})
@JsonTypeName(value="Admin_ServerConfiguration")
@JsonIgnoreProperties(value={"configurationType"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configurationType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AdminApplicationConfiguration.class, name="application"), @JsonSubTypes.Type(value=AdminLogConfiguration.class, name="log"), @JsonSubTypes.Type(value=AdminServerConfiguration.class, name="server"), @JsonSubTypes.Type(value=AdminUserConfiguration.class, name="user")})
public class AdminServerConfiguration
extends AdminConfiguration {
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private ServerConfigServer _configuration;
    public static final String JSON_PROPERTY_CONFIGURATION_CHECKS = "configurationChecks";
    private List<AdminServerCheck> configurationChecks = new ArrayList<AdminServerCheck>();
    public static final String JSON_PROPERTY_CONNECTOR_KEY_STORE = "connectorKeyStore";
    private Map<String, AdminConnectorKeyStore> connectorKeyStore = null;
    public static final String JSON_PROPERTY_TRUST_STORE_KEY_STORE = "trustStoreKeyStore";
    private AdminTrustStoreKeyStore trustStoreKeyStore;

    public AdminServerConfiguration _configuration(ServerConfigServer _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public ServerConfigServer getConfiguration() {
        return this._configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConfiguration(ServerConfigServer _configuration) {
        this._configuration = _configuration;
    }

    public AdminServerConfiguration configurationChecks(List<AdminServerCheck> configurationChecks) {
        this.configurationChecks = configurationChecks;
        return this;
    }

    public AdminServerConfiguration addConfigurationChecksItem(AdminServerCheck configurationChecksItem) {
        this.configurationChecks.add(configurationChecksItem);
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="configurationChecks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<AdminServerCheck> getConfigurationChecks() {
        return this.configurationChecks;
    }

    @JsonProperty(value="configurationChecks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConfigurationChecks(List<AdminServerCheck> configurationChecks) {
        this.configurationChecks = configurationChecks;
    }

    public AdminServerConfiguration connectorKeyStore(Map<String, AdminConnectorKeyStore> connectorKeyStore) {
        this.connectorKeyStore = connectorKeyStore;
        return this;
    }

    public AdminServerConfiguration putConnectorKeyStoreItem(String key, AdminConnectorKeyStore connectorKeyStoreItem) {
        if (this.connectorKeyStore == null) {
            this.connectorKeyStore = new HashMap<String, AdminConnectorKeyStore>();
        }
        this.connectorKeyStore.put(key, connectorKeyStoreItem);
        return this;
    }

    @Schema(name="Lists all contents of the keystore (e.g. it\u00b4s certificates and raw data), that shall be used by theserver\u00b4s secured SSL connectors.")
    @JsonProperty(value="connectorKeyStore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Map<String, AdminConnectorKeyStore> getConnectorKeyStore() {
        return this.connectorKeyStore;
    }

    @JsonProperty(value="connectorKeyStore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectorKeyStore(Map<String, AdminConnectorKeyStore> connectorKeyStore) {
        this.connectorKeyStore = connectorKeyStore;
    }

    public AdminServerConfiguration trustStoreKeyStore(AdminTrustStoreKeyStore trustStoreKeyStore) {
        this.trustStoreKeyStore = trustStoreKeyStore;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="trustStoreKeyStore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminTrustStoreKeyStore getTrustStoreKeyStore() {
        return this.trustStoreKeyStore;
    }

    @JsonProperty(value="trustStoreKeyStore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrustStoreKeyStore(AdminTrustStoreKeyStore trustStoreKeyStore) {
        this.trustStoreKeyStore = trustStoreKeyStore;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminServerConfiguration adminServerConfiguration = (AdminServerConfiguration)o;
        return Objects.equals(this._configuration, adminServerConfiguration._configuration) && Objects.equals(this.configurationChecks, adminServerConfiguration.configurationChecks) && Objects.equals(this.connectorKeyStore, adminServerConfiguration.connectorKeyStore) && Objects.equals(this.trustStoreKeyStore, adminServerConfiguration.trustStoreKeyStore) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this._configuration, this.configurationChecks, this.connectorKeyStore, this.trustStoreKeyStore, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminServerConfiguration {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    configurationChecks: ").append(this.toIndentedString(this.configurationChecks)).append("\n");
        sb.append("    connectorKeyStore: ").append(this.toIndentedString(this.connectorKeyStore)).append("\n");
        sb.append("    trustStoreKeyStore: ").append(this.toIndentedString(this.trustStoreKeyStore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

