
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ZugferdVersionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="ZugferdVersionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="v10Comfort"/>
 *     <enumeration value="v20Minimum"/>
 *     <enumeration value="v20BasicWL"/>
 *     <enumeration value="v20Basic"/>
 *     <enumeration value="v20EN16931"/>
 *     <enumeration value="v20Extended"/>
 *     <enumeration value="v21Minimum"/>
 *     <enumeration value="v21BasicWL"/>
 *     <enumeration value="v21Basic"/>
 *     <enumeration value="v21EN16931"/>
 *     <enumeration value="v21Extended"/>
 *     <enumeration value="v21XRechnung"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ZugferdVersionType")
@XmlEnum
public enum ZugferdVersionType {

    @XmlEnumValue("v10Comfort")
    V_10_COMFORT("v10Comfort"),
    @XmlEnumValue("v20Minimum")
    V_20_MINIMUM("v20Minimum"),
    @XmlEnumValue("v20BasicWL")
    V_20_BASIC_WL("v20BasicWL"),
    @XmlEnumValue("v20Basic")
    V_20_BASIC("v20Basic"),
    @XmlEnumValue("v20EN16931")
    V_20_EN_16931("v20EN16931"),
    @XmlEnumValue("v20Extended")
    V_20_EXTENDED("v20Extended"),
    @XmlEnumValue("v21Minimum")
    V_21_MINIMUM("v21Minimum"),
    @XmlEnumValue("v21BasicWL")
    V_21_BASIC_WL("v21BasicWL"),
    @XmlEnumValue("v21Basic")
    V_21_BASIC("v21Basic"),
    @XmlEnumValue("v21EN16931")
    V_21_EN_16931("v21EN16931"),
    @XmlEnumValue("v21Extended")
    V_21_EXTENDED("v21Extended"),
    @XmlEnumValue("v21XRechnung")
    V_21_X_RECHNUNG("v21XRechnung");
    private final String value;

    ZugferdVersionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ZugferdVersionType fromValue(String v) {
        for (ZugferdVersionType c: ZugferdVersionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
