
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a target TIFF image format.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for TiffType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TiffType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ImageBaseType">
 *       <attribute name="multipage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="compression" type="{http://schema.webpdf.de/1.0/operation}TiffCompressionType" default="none" />
 *       <attribute name="jpegQuality" default="80">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="blackAndWhiteQuality" type="{http://schema.webpdf.de/1.0/operation}TiffBlackAndWhiteQualityType" default="high" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TiffType")
public class TiffType
    extends ImageBaseType
{

    @XmlAttribute(name = "multipage")
    protected Boolean multipage;
    @XmlAttribute(name = "compression")
    protected TiffCompressionType compression;
    @XmlAttribute(name = "jpegQuality")
    protected Integer jpegQuality;
    @XmlAttribute(name = "blackAndWhiteQuality")
    protected TiffBlackAndWhiteQualityType blackAndWhiteQuality;

    /**
     * Gets the value of the multipage property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMultipage() {
        if (multipage == null) {
            return false;
        } else {
            return multipage;
        }
    }

    /**
     * Sets the value of the multipage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMultipage(boolean value) {
        this.multipage = value;
    }

    public boolean isSetMultipage() {
        return (this.multipage!= null);
    }

    public void unsetMultipage() {
        this.multipage = null;
    }

    /**
     * Gets the value of the compression property.
     * 
     * @return
     *     possible object is
     *     {@link TiffCompressionType }
     *     
     */
    public TiffCompressionType getCompression() {
        if (compression == null) {
            return TiffCompressionType.NONE;
        } else {
            return compression;
        }
    }

    /**
     * Sets the value of the compression property.
     * 
     * @param value
     *     allowed object is
     *     {@link TiffCompressionType }
     *     
     */
    public void setCompression(TiffCompressionType value) {
        this.compression = value;
    }

    public boolean isSetCompression() {
        return (this.compression!= null);
    }

    /**
     * Gets the value of the jpegQuality property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getJpegQuality() {
        if (jpegQuality == null) {
            return  80;
        } else {
            return jpegQuality;
        }
    }

    /**
     * Sets the value of the jpegQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setJpegQuality(int value) {
        this.jpegQuality = value;
    }

    public boolean isSetJpegQuality() {
        return (this.jpegQuality!= null);
    }

    public void unsetJpegQuality() {
        this.jpegQuality = null;
    }

    /**
     * Gets the value of the blackAndWhiteQuality property.
     * 
     * @return
     *     possible object is
     *     {@link TiffBlackAndWhiteQualityType }
     *     
     */
    public TiffBlackAndWhiteQualityType getBlackAndWhiteQuality() {
        if (blackAndWhiteQuality == null) {
            return TiffBlackAndWhiteQualityType.HIGH;
        } else {
            return blackAndWhiteQuality;
        }
    }

    /**
     * Sets the value of the blackAndWhiteQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link TiffBlackAndWhiteQualityType }
     *     
     */
    public void setBlackAndWhiteQuality(TiffBlackAndWhiteQualityType value) {
        this.blackAndWhiteQuality = value;
    }

    public boolean isSetBlackAndWhiteQuality() {
        return (this.blackAndWhiteQuality!= null);
    }

}
