
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects parameters for the creation of SVGs, possibly contained in resulting documents.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for SvgFormatType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SvgFormatType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="decimalPrecision" default="2">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="10"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="graphicsStateMode" default="centralize">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}SvgGraphicsStateModeType">
 *             <enumeration value="verbose"/>
 *             <enumeration value="centralize"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pathDrawMode" default="compact">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}SvgPathDrawModeType">
 *             <enumeration value="verbose"/>
 *             <enumeration value="compact"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SvgFormatType")
public class SvgFormatType {

    @XmlAttribute(name = "decimalPrecision")
    protected Integer decimalPrecision;
    @XmlAttribute(name = "graphicsStateMode")
    protected SvgGraphicsStateModeType graphicsStateMode;
    @XmlAttribute(name = "pathDrawMode")
    protected SvgPathDrawModeType pathDrawMode;

    /**
     * Gets the value of the decimalPrecision property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDecimalPrecision() {
        if (decimalPrecision == null) {
            return  2;
        } else {
            return decimalPrecision;
        }
    }

    /**
     * Sets the value of the decimalPrecision property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setDecimalPrecision(int value) {
        this.decimalPrecision = value;
    }

    public boolean isSetDecimalPrecision() {
        return (this.decimalPrecision!= null);
    }

    public void unsetDecimalPrecision() {
        this.decimalPrecision = null;
    }

    /**
     * Gets the value of the graphicsStateMode property.
     * 
     * @return
     *     possible object is
     *     {@link SvgGraphicsStateModeType }
     *     
     */
    public SvgGraphicsStateModeType getGraphicsStateMode() {
        if (graphicsStateMode == null) {
            return SvgGraphicsStateModeType.CENTRALIZE;
        } else {
            return graphicsStateMode;
        }
    }

    /**
     * Sets the value of the graphicsStateMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgGraphicsStateModeType }
     *     
     */
    public void setGraphicsStateMode(SvgGraphicsStateModeType value) {
        this.graphicsStateMode = value;
    }

    public boolean isSetGraphicsStateMode() {
        return (this.graphicsStateMode!= null);
    }

    /**
     * Gets the value of the pathDrawMode property.
     * 
     * @return
     *     possible object is
     *     {@link SvgPathDrawModeType }
     *     
     */
    public SvgPathDrawModeType getPathDrawMode() {
        if (pathDrawMode == null) {
            return SvgPathDrawModeType.COMPACT;
        } else {
            return pathDrawMode;
        }
    }

    /**
     * Sets the value of the pathDrawMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SvgPathDrawModeType }
     *     
     */
    public void setPathDrawMode(SvgPathDrawModeType value) {
        this.pathDrawMode = value;
    }

    public boolean isSetPathDrawMode() {
        return (this.pathDrawMode!= null);
    }

}
