
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p244362_="https://jakarta.ee/xml/ns/jaxb" xmlns:p344054_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to configure global settings that should be respected when running the web service operation. This concerns e.g. settings whether the execution of the operation is allowed within the scope of the PDF document settings or how the result of the operation should be handled.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for SettingsType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SettingsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="signature" type="{http://schema.webpdf.de/1.0/operation}SignatureSettingsType" minOccurs="0"/>
 *         <element name="compress" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <all>
 *                   <element name="compressObjects" type="{http://schema.webpdf.de/1.0/operation}CompressObjectsType" minOccurs="0"/>
 *                 </all>
 *                 <attribute name="compressProfile" type="{http://schema.webpdf.de/1.0/operation}CompressProfileType" default="never" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaSettingsType" minOccurs="0"/>
 *       </all>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SettingsType", propOrder = {

})
public class SettingsType {

    protected SignatureSettingsType signature;
    protected SettingsType.Compress compress;
    protected PdfaSettingsType pdfa;

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureSettingsType }
     *     
     */
    public SignatureSettingsType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureSettingsType }
     *     
     */
    public void setSignature(SignatureSettingsType value) {
        this.signature = value;
    }

    public boolean isSetSignature() {
        return (this.signature!= null);
    }

    /**
     * Gets the value of the compress property.
     * 
     * @return
     *     possible object is
     *     {@link SettingsType.Compress }
     *     
     */
    public SettingsType.Compress getCompress() {
        return compress;
    }

    /**
     * Sets the value of the compress property.
     * 
     * @param value
     *     allowed object is
     *     {@link SettingsType.Compress }
     *     
     */
    public void setCompress(SettingsType.Compress value) {
        this.compress = value;
    }

    public boolean isSetCompress() {
        return (this.compress!= null);
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaSettingsType }
     *     
     */
    public PdfaSettingsType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaSettingsType }
     *     
     */
    public void setPdfa(PdfaSettingsType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <all>
     *         <element name="compressObjects" type="{http://schema.webpdf.de/1.0/operation}CompressObjectsType" minOccurs="0"/>
     *       </all>
     *       <attribute name="compressProfile" type="{http://schema.webpdf.de/1.0/operation}CompressProfileType" default="never" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {

    })
    public static class Compress {

        protected CompressObjectsType compressObjects;
        @XmlAttribute(name = "compressProfile")
        protected CompressProfileType compressProfile;

        /**
         * Gets the value of the compressObjects property.
         * 
         * @return
         *     possible object is
         *     {@link CompressObjectsType }
         *     
         */
        public CompressObjectsType getCompressObjects() {
            return compressObjects;
        }

        /**
         * Sets the value of the compressObjects property.
         * 
         * @param value
         *     allowed object is
         *     {@link CompressObjectsType }
         *     
         */
        public void setCompressObjects(CompressObjectsType value) {
            this.compressObjects = value;
        }

        public boolean isSetCompressObjects() {
            return (this.compressObjects!= null);
        }

        /**
         * Gets the value of the compressProfile property.
         * 
         * @return
         *     possible object is
         *     {@link CompressProfileType }
         *     
         */
        public CompressProfileType getCompressProfile() {
            if (compressProfile == null) {
                return CompressProfileType.NEVER;
            } else {
                return compressProfile;
            }
        }

        /**
         * Sets the value of the compressProfile property.
         * 
         * @param value
         *     allowed object is
         *     {@link CompressProfileType }
         *     
         */
        public void setCompressProfile(CompressProfileType value) {
            this.compressProfile = value;
        }

        public boolean isSetCompressProfile() {
            return (this.compressProfile!= null);
        }

    }

}
