
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this function is enabled, all the selected pages in the document will be flattened. When this is done, an image of the visible contents in the corresponding page will be generated and will be used to replace all the page contents. This will remove any complex content that may be hiding confidential data.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for SanitizePagesType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SanitizePagesType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}SanitizeOptionsType">
 *       <attribute name="dpi" default="72">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}DpiType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="*" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SanitizePagesType")
public class SanitizePagesType
    extends SanitizeOptionsType
{

    @XmlAttribute(name = "dpi")
    protected Integer dpi;
    @XmlAttribute(name = "pages")
    protected String pages;

    /**
     * Gets the value of the dpi property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  72;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

    /**
     * Gets the value of the pages property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "*";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

}
