
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the format to which resources shall be extracted.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ResourceExtractionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ResourceExtractionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="fileFormat" default="zip">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}ExtractionFileFormatType">
 *             <enumeration value="zip"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ResourceExtractionType")
@XmlSeeAlso({
    ExtractionImagesType.class
})
public class ResourceExtractionType {

    @XmlAttribute(name = "fileFormat")
    protected ExtractionFileFormatType fileFormat;
    @XmlAttribute(name = "pages")
    protected String pages;

    /**
     * Gets the value of the fileFormat property.
     * 
     * @return
     *     possible object is
     *     {@link ExtractionFileFormatType }
     *     
     */
    public ExtractionFileFormatType getFileFormat() {
        if (fileFormat == null) {
            return ExtractionFileFormatType.ZIP;
        } else {
            return fileFormat;
        }
    }

    /**
     * Sets the value of the fileFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtractionFileFormatType }
     *     
     */
    public void setFileFormat(ExtractionFileFormatType value) {
        this.fileFormat = value;
    }

    public boolean isSetFileFormat() {
        return (this.fileFormat!= null);
    }

    /**
     * Gets the value of the pages property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

}
