
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p168493_="https://jakarta.ee/xml/ns/jaxb" xmlns:p650548_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p838011_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a document to the portfolio.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for PortfolioAddType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="PortfolioAddType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice maxOccurs="unbounded">
 *         <element name="file" type="{http://schema.webpdf.de/1.0/operation}PortfolioFileType"/>
 *         <element name="folder" type="{http://schema.webpdf.de/1.0/operation}PortfolioFolderType"/>
 *       </choice>
 *       <attribute name="initialDocumentPath" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="initialFileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PortfolioAddType", propOrder = {
    "file",
    "folder"
})
public class PortfolioAddType {

    protected List<PortfolioFileType> file;
    protected List<PortfolioFolderType> folder;
    @XmlAttribute(name = "initialDocumentPath")
    protected String initialDocumentPath;
    @XmlAttribute(name = "initialFileName")
    protected String initialFileName;

    /**
     * Gets the value of the file property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the file property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PortfolioFileType }
     * 
     * 
     * @return
     *     The value of the file property.
     */
    public List<PortfolioFileType> getFile() {
        if (file == null) {
            file = new ArrayList<>();
        }
        return this.file;
    }

    /**
     * Gets the value of the folder property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the folder property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFolder().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PortfolioFolderType }
     * 
     * 
     * @return
     *     The value of the folder property.
     */
    public List<PortfolioFolderType> getFolder() {
        if (folder == null) {
            folder = new ArrayList<>();
        }
        return this.folder;
    }

    /**
     * Gets the value of the initialDocumentPath property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInitialDocumentPath() {
        if (initialDocumentPath == null) {
            return "";
        } else {
            return initialDocumentPath;
        }
    }

    /**
     * Sets the value of the initialDocumentPath property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInitialDocumentPath(String value) {
        this.initialDocumentPath = value;
    }

    public boolean isSetInitialDocumentPath() {
        return (this.initialDocumentPath!= null);
    }

    /**
     * Gets the value of the initialFileName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInitialFileName() {
        if (initialFileName == null) {
            return "";
        } else {
            return initialFileName;
        }
    }

    /**
     * Sets the value of the initialFileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInitialFileName(String value) {
        this.initialFileName = value;
    }

    public boolean isSetInitialFileName() {
        return (this.initialFileName!= null);
    }

}
