
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PdfaLevelType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PdfaLevelType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="1a"/>
 *     <enumeration value="1b"/>
 *     <enumeration value="2a"/>
 *     <enumeration value="2b"/>
 *     <enumeration value="2u"/>
 *     <enumeration value="3a"/>
 *     <enumeration value="3b"/>
 *     <enumeration value="3u"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfaLevelType")
@XmlEnum
public enum PdfaLevelType {

    @XmlEnumValue("1a")
    LEVEL_1A("1a"),
    @XmlEnumValue("1b")
    LEVEL_1B("1b"),
    @XmlEnumValue("2a")
    LEVEL_2A("2a"),
    @XmlEnumValue("2b")
    LEVEL_2B("2b"),
    @XmlEnumValue("2u")
    LEVEL_2U("2u"),
    @XmlEnumValue("3a")
    LEVEL_3A("3a"),
    @XmlEnumValue("3b")
    LEVEL_3B("3b"),
    @XmlEnumValue("3u")
    LEVEL_3U("3u");
    private final String value;

    PdfaLevelType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PdfaLevelType fromValue(String v) {
        for (PdfaLevelType c: PdfaLevelType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
