
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PdfEncryptionKeyType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PdfEncryptionKeyType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="RC4_40"/>
 *     <enumeration value="RC4_128"/>
 *     <enumeration value="AES_128"/>
 *     <enumeration value="AES_256"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfEncryptionKeyType")
@XmlEnum
public enum PdfEncryptionKeyType {

    @XmlEnumValue("RC4_40")
    RC_4_40("RC4_40"),
    @XmlEnumValue("RC4_128")
    RC_4_128("RC4_128"),
    AES_128("AES_128"),
    AES_256("AES_256");
    private final String value;

    PdfEncryptionKeyType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PdfEncryptionKeyType fromValue(String v) {
        for (PdfEncryptionKeyType c: PdfEncryptionKeyType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
