
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PdfContentEncryptionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PdfContentEncryptionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="encryptEverything"/>
 *     <enumeration value="exposeMetadata"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfContentEncryptionType")
@XmlEnum
public enum PdfContentEncryptionType {

    @XmlEnumValue("encryptEverything")
    ENCRYPT_EVERYTHING("encryptEverything"),
    @XmlEnumValue("exposeMetadata")
    EXPOSE_METADATA("exposeMetadata");
    private final String value;

    PdfContentEncryptionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PdfContentEncryptionType fromValue(String v) {
        for (PdfContentEncryptionType c: PdfContentEncryptionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
