
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PageBoxType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PageBoxType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="media_box"/>
 *     <enumeration value="crop_box"/>
 *     <enumeration value="bleed_box"/>
 *     <enumeration value="trim_box"/>
 *     <enumeration value="art_box"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageBoxType")
@XmlEnum
public enum PageBoxType {

    @XmlEnumValue("media_box")
    MEDIA_BOX("media_box"),
    @XmlEnumValue("crop_box")
    CROP_BOX("crop_box"),
    @XmlEnumValue("bleed_box")
    BLEED_BOX("bleed_box"),
    @XmlEnumValue("trim_box")
    TRIM_BOX("trim_box"),
    @XmlEnumValue("art_box")
    ART_BOX("art_box");
    private final String value;

    PageBoxType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PageBoxType fromValue(String v) {
        for (PageBoxType c: PageBoxType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
