
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OutlineTransitionDirectionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="OutlineTransitionDirectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="leftToRight"/>
 *     <enumeration value="bottomToTop"/>
 *     <enumeration value="rightToLeft"/>
 *     <enumeration value="topToBottom"/>
 *     <enumeration value="topLeftToBottomRight"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OutlineTransitionDirectionType")
@XmlEnum
public enum OutlineTransitionDirectionType {

    @XmlEnumValue("leftToRight")
    LEFT_TO_RIGHT("leftToRight"),
    @XmlEnumValue("bottomToTop")
    BOTTOM_TO_TOP("bottomToTop"),
    @XmlEnumValue("rightToLeft")
    RIGHT_TO_LEFT("rightToLeft"),
    @XmlEnumValue("topToBottom")
    TOP_TO_BOTTOM("topToBottom"),
    @XmlEnumValue("topLeftToBottomRight")
    TOP_LEFT_TO_BOTTOM_RIGHT("topLeftToBottomRight"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    OutlineTransitionDirectionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static OutlineTransitionDirectionType fromValue(String v) {
        for (OutlineTransitionDirectionType c: OutlineTransitionDirectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
