
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MoveModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="MoveModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="beforePage"/>
 *     <enumeration value="afterPage"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MoveModeType")
@XmlEnum
public enum MoveModeType {

    @XmlEnumValue("beforePage")
    BEFORE_PAGE("beforePage"),
    @XmlEnumValue("afterPage")
    AFTER_PAGE("afterPage");
    private final String value;

    MoveModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MoveModeType fromValue(String v) {
        for (MoveModeType c: MoveModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
