
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MarkupsAnnotationType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="MarkupsAnnotationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="highlight"/>
 *     <enumeration value="underline"/>
 *     <enumeration value="strikeOut"/>
 *     <enumeration value="squiggly"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MarkupsAnnotationType")
@XmlEnum
public enum MarkupsAnnotationType {

    @XmlEnumValue("highlight")
    HIGHLIGHT("highlight"),
    @XmlEnumValue("underline")
    UNDERLINE("underline"),
    @XmlEnumValue("strikeOut")
    STRIKE_OUT("strikeOut"),
    @XmlEnumValue("squiggly")
    SQUIGGLY("squiggly");
    private final String value;

    MarkupsAnnotationType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MarkupsAnnotationType fromValue(String v) {
        for (MarkupsAnnotationType c: MarkupsAnnotationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
