
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When activated, the hide element will show or hide the selected annotations.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for HideActionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="HideActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <choice>
 *         <element name="annotation" type="{http://schema.webpdf.de/1.0/operation}AnnotationSelectionType" maxOccurs="unbounded"/>
 *       </choice>
 *       <attribute name="hide" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "HideActionType", propOrder = {
    "annotation"
})
public class HideActionType
    extends ActionEventType
{

    protected List<AnnotationSelectionType> annotation;
    @XmlAttribute(name = "hide")
    protected Boolean hide;

    /**
     * Gets the value of the annotation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the annotation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAnnotation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AnnotationSelectionType }
     * 
     * 
     * @return
     *     The value of the annotation property.
     */
    public List<AnnotationSelectionType> getAnnotation() {
        if (annotation == null) {
            annotation = new ArrayList<>();
        }
        return this.annotation;
    }

    public boolean isSetAnnotation() {
        return ((this.annotation!= null)&&(!this.annotation.isEmpty()));
    }

    public void unsetAnnotation() {
        this.annotation = null;
    }

    /**
     * Gets the value of the hide property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHide() {
        if (hide == null) {
            return true;
        } else {
            return hide;
        }
    }

    /**
     * Sets the value of the hide property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHide(boolean value) {
        this.hide = value;
    }

    public boolean isSetHide() {
        return (this.hide!= null);
    }

    public void unsetHide() {
        this.hide = null;
    }

}
