
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p18901_="https://jakarta.ee/xml/ns/jaxb" xmlns:p595380_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define an individual file attachment that should be added to the PDF document. This element can be used multiple times if you want to add multiple files.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for FileAttachmentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="FileAttachmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}AttachmentFileDataType"/>
 *         <element name="annotation" type="{http://schema.webpdf.de/1.0/operation}FileAnnotationType" minOccurs="0"/>
 *       </all>
 *       <attribute name="fileName" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="mimeType" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FileAttachmentType", propOrder = {

})
public class FileAttachmentType {

    @XmlElement(required = true)
    protected AttachmentFileDataType data;
    protected FileAnnotationType annotation;
    @XmlAttribute(name = "fileName", required = true)
    protected String fileName;
    @XmlAttribute(name = "mimeType")
    protected String mimeType;
    @XmlAttribute(name = "creator")
    protected String creator;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link AttachmentFileDataType }
     *     
     */
    public AttachmentFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link AttachmentFileDataType }
     *     
     */
    public void setData(AttachmentFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * Gets the value of the annotation property.
     * 
     * @return
     *     possible object is
     *     {@link FileAnnotationType }
     *     
     */
    public FileAnnotationType getAnnotation() {
        return annotation;
    }

    /**
     * Sets the value of the annotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileAnnotationType }
     *     
     */
    public void setAnnotation(FileAnnotationType value) {
        this.annotation = value;
    }

    public boolean isSetAnnotation() {
        return (this.annotation!= null);
    }

    /**
     * Gets the value of the fileName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * Sets the value of the fileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFileName(String value) {
        this.fileName = value;
    }

    public boolean isSetFileName() {
        return (this.fileName!= null);
    }

    /**
     * Gets the value of the mimeType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMimeType() {
        if (mimeType == null) {
            return "";
        } else {
            return mimeType;
        }
    }

    /**
     * Sets the value of the mimeType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMimeType(String value) {
        this.mimeType = value;
    }

    public boolean isSetMimeType() {
        return (this.mimeType!= null);
    }

    /**
     * Gets the value of the creator property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    public boolean isSetCreator() {
        return (this.creator!= null);
    }

}
