
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Extract the PDF document's image contents&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Generates a ZIP file that is returned as a result when the web service is called. This file will contain all the images contained at the page level in a freely selectable page range.&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;p&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                         The images mode can only be used to extract raster graphics (bitmap images). The extraction vector graphics, as well as the rendering of vector graphics based on vectorial drawing paths, is not supported.&#13;
 *                     &lt;/p&gt;&lt;p&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                         Due to licensing reasons, the images mode currently only supports the extraction of basic JPEG2000 images that conform to the part-1 core coding system definition in ISO/IEC 15444-1.&#13;
 *                     &lt;/p&gt;&lt;p&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                         It cannot be guaranteed that an image will be exported in its original source format, as the image may have already been converted when embedded in the PDF (this depends on whether the source format was supported by the PDF standard and on the application that was used to embed the image).&#13;
 *                     &lt;/p&gt;&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ExtractionImagesType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ExtractionImagesType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ResourceExtractionType">
 *       <attribute name="fileNameTemplate" type="{http://www.w3.org/2001/XMLSchema}string" default="file[%d]" />
 *       <attribute name="folderNameTemplate" type="{http://www.w3.org/2001/XMLSchema}string" default="page[%d]" />
 *       <attribute name="fallbackFormat" default="png">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}ExtractionImageFormat">
 *             <enumeration value="jpeg"/>
 *             <enumeration value="png"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExtractionImagesType")
public class ExtractionImagesType
    extends ResourceExtractionType
{

    @XmlAttribute(name = "fileNameTemplate")
    protected String fileNameTemplate;
    @XmlAttribute(name = "folderNameTemplate")
    protected String folderNameTemplate;
    @XmlAttribute(name = "fallbackFormat")
    protected ExtractionImageFormat fallbackFormat;

    /**
     * Gets the value of the fileNameTemplate property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileNameTemplate() {
        if (fileNameTemplate == null) {
            return "file[%d]";
        } else {
            return fileNameTemplate;
        }
    }

    /**
     * Sets the value of the fileNameTemplate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFileNameTemplate(String value) {
        this.fileNameTemplate = value;
    }

    public boolean isSetFileNameTemplate() {
        return (this.fileNameTemplate!= null);
    }

    /**
     * Gets the value of the folderNameTemplate property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFolderNameTemplate() {
        if (folderNameTemplate == null) {
            return "page[%d]";
        } else {
            return folderNameTemplate;
        }
    }

    /**
     * Sets the value of the folderNameTemplate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFolderNameTemplate(String value) {
        this.folderNameTemplate = value;
    }

    public boolean isSetFolderNameTemplate() {
        return (this.folderNameTemplate!= null);
    }

    /**
     * Gets the value of the fallbackFormat property.
     * 
     * @return
     *     possible object is
     *     {@link ExtractionImageFormat }
     *     
     */
    public ExtractionImageFormat getFallbackFormat() {
        if (fallbackFormat == null) {
            return ExtractionImageFormat.PNG;
        } else {
            return fallbackFormat;
        }
    }

    /**
     * Sets the value of the fallbackFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtractionImageFormat }
     *     
     */
    public void setFallbackFormat(ExtractionImageFormat value) {
        this.fallbackFormat = value;
    }

    public boolean isSetFallbackFormat() {
        return (this.fallbackFormat!= null);
    }

}
