
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for DrawModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="DrawModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="fill"/>
 *     <enumeration value="stroke"/>
 *     <enumeration value="fillAndStroke"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DrawModeType")
@XmlEnum
public enum DrawModeType {

    @XmlEnumValue("fill")
    FILL("fill"),
    @XmlEnumValue("stroke")
    STROKE("stroke"),
    @XmlEnumValue("fillAndStroke")
    FILL_AND_STROKE("fillAndStroke");
    private final String value;

    DrawModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static DrawModeType fromValue(String v) {
        for (DrawModeType c: DrawModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
