
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for DataMatrixShapeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="DataMatrixShapeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="default"/>
 *     <enumeration value="rectangle"/>
 *     <enumeration value="square"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DataMatrixShapeType")
@XmlEnum
public enum DataMatrixShapeType {

    @XmlEnumValue("default")
    DEFAULT("default"),
    @XmlEnumValue("rectangle")
    RECTANGLE("rectangle"),
    @XmlEnumValue("square")
    SQUARE("square");
    private final String value;

    DataMatrixShapeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static DataMatrixShapeType fromValue(String v) {
        for (DataMatrixShapeType c: DataMatrixShapeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
