
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p729701_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p909447_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The settings are used in purely text-based files that can contain source code that would make syntax highlighting advisable. If you configure this element, the system will attempt, during conversion, to detect whether and in which programming/script language content is stored. Based on the result, it will then determine the type of highlighting (in the generated PDF document) is required.&#13;
 *                     SyntaxHighlighter and TextHighlighter are specified alternately. If the syntax highlighter is unable to determine whether the contents belong to any language it knows, the text highlighter will be used instead for formatting.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ConverterTextType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ConverterTextType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="syntaxHighlight" type="{http://schema.webpdf.de/1.0/operation}SyntaxHighlightType" minOccurs="0"/>
 *         <element name="textHighlight" type="{http://schema.webpdf.de/1.0/operation}TextHighlightType" minOccurs="0"/>
 *       </all>
 *       <attribute name="useSyntaxDetection" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConverterTextType", propOrder = {

})
public class ConverterTextType {

    protected SyntaxHighlightType syntaxHighlight;
    protected TextHighlightType textHighlight;
    @XmlAttribute(name = "useSyntaxDetection")
    protected Boolean useSyntaxDetection;

    /**
     * Gets the value of the syntaxHighlight property.
     * 
     * @return
     *     possible object is
     *     {@link SyntaxHighlightType }
     *     
     */
    public SyntaxHighlightType getSyntaxHighlight() {
        return syntaxHighlight;
    }

    /**
     * Sets the value of the syntaxHighlight property.
     * 
     * @param value
     *     allowed object is
     *     {@link SyntaxHighlightType }
     *     
     */
    public void setSyntaxHighlight(SyntaxHighlightType value) {
        this.syntaxHighlight = value;
    }

    public boolean isSetSyntaxHighlight() {
        return (this.syntaxHighlight!= null);
    }

    /**
     * Gets the value of the textHighlight property.
     * 
     * @return
     *     possible object is
     *     {@link TextHighlightType }
     *     
     */
    public TextHighlightType getTextHighlight() {
        return textHighlight;
    }

    /**
     * Sets the value of the textHighlight property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextHighlightType }
     *     
     */
    public void setTextHighlight(TextHighlightType value) {
        this.textHighlight = value;
    }

    public boolean isSetTextHighlight() {
        return (this.textHighlight!= null);
    }

    /**
     * Gets the value of the useSyntaxDetection property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUseSyntaxDetection() {
        if (useSyntaxDetection == null) {
            return false;
        } else {
            return useSyntaxDetection;
        }
    }

    /**
     * Sets the value of the useSyntaxDetection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setUseSyntaxDetection(boolean value) {
        this.useSyntaxDetection = value;
    }

    public boolean isSetUseSyntaxDetection() {
        return (this.useSyntaxDetection!= null);
    }

    public void unsetUseSyntaxDetection() {
        this.useSyntaxDetection = null;
    }

}
