
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p523158_="https://jakarta.ee/xml/ns/jaxb" xmlns:p795835_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p918168_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;All barcode elements have a number of basic attributes in common. These attributes are described via this base type.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for BaseBarcodeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="BaseBarcodeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}RectangleType" minOccurs="0"/>
 *       </all>
 *       <attribute name="charset" type="{http://www.w3.org/2001/XMLSchema}string" default="utf-8" />
 *       <attribute name="value" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="rotation" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxExclusive value="360"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="margin" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pages" default="">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BaseBarcodeType", propOrder = {

})
@XmlSeeAlso({
    QrBarcodeType.class,
    Pdf417BarcodeType.class,
    DataMatrixBarcodeType.class,
    AztecBarcodeType.class,
    CodabarBarcodeType.class,
    Code128BarcodeType.class,
    Code39BarcodeType.class,
    Ean13BarcodeType.class,
    Ean8BarcodeType.class,
    ItfBarcodeType.class,
    UpcaBarcodeType.class
})
public class BaseBarcodeType {

    protected RectangleType position;
    @XmlAttribute(name = "charset")
    protected String charset;
    @XmlAttribute(name = "value", required = true)
    protected String value;
    @XmlAttribute(name = "rotation")
    protected Integer rotation;
    @XmlAttribute(name = "margin")
    protected Integer margin;
    @XmlAttribute(name = "pages")
    protected String pages;

    /**
     * Gets the value of the position property.
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     */
    public void setPosition(RectangleType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * Gets the value of the charset property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCharset() {
        if (charset == null) {
            return "utf-8";
        } else {
            return charset;
        }
    }

    /**
     * Sets the value of the charset property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCharset(String value) {
        this.charset = value;
    }

    public boolean isSetCharset() {
        return (this.charset!= null);
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * Gets the value of the rotation property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRotation() {
        if (rotation == null) {
            return  0;
        } else {
            return rotation;
        }
    }

    /**
     * Sets the value of the rotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setRotation(int value) {
        this.rotation = value;
    }

    public boolean isSetRotation() {
        return (this.rotation!= null);
    }

    public void unsetRotation() {
        this.rotation = null;
    }

    /**
     * Gets the value of the margin property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMargin() {
        if (margin == null) {
            return  0;
        } else {
            return margin;
        }
    }

    /**
     * Sets the value of the margin property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setMargin(int value) {
        this.margin = value;
    }

    public boolean isSetMargin() {
        return (this.margin!= null);
    }

    public void unsetMargin() {
        this.margin = null;
    }

    /**
     * Gets the value of the pages property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

}
