
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p135820_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p874817_="https://jakarta.ee/xml/ns/jaxb" xmlns:p942898_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;All annotation elements have a number of basic attributes in common. These attributes are described by this base type.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for BaseAnnotationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="BaseAnnotationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FlagsAnnotationGroup"/>
 *       <attribute name="creator" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="subject" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="contents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="intents" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#4800FF" />
 *       <attribute name="opacity" type="{http://schema.webpdf.de/1.0/operation}OpacityType" default="100" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BaseAnnotationType")
@XmlSeeAlso({
    TextAnnotationType.class,
    MarkupAnnotationType.class,
    RedactAnnotationType.class,
    FreeTextAnnotationType.class,
    RubberStampAnnotationType.class,
    SimpleShapeAnnotationType.class,
    LineAnnotationType.class
})
public class BaseAnnotationType {

    @XmlAttribute(name = "creator")
    protected String creator;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "subject")
    protected String subject;
    @XmlAttribute(name = "contents")
    protected String contents;
    @XmlAttribute(name = "intents")
    protected String intents;
    @XmlAttribute(name = "page")
    protected Integer page;
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;
    @XmlAttribute(name = "opacity")
    protected Integer opacity;
    @XmlAttribute(name = "locked")
    protected Boolean locked;
    @XmlAttribute(name = "printable")
    protected Boolean printable;
    @XmlAttribute(name = "rotatable")
    protected Boolean rotatable;
    @XmlAttribute(name = "viewable")
    protected Boolean viewable;
    @XmlAttribute(name = "writable")
    protected Boolean writable;
    @XmlAttribute(name = "zoomable")
    protected Boolean zoomable;
    @XmlAttribute(name = "invisible")
    protected Boolean invisible;
    @XmlAttribute(name = "hidden")
    protected Boolean hidden;

    /**
     * Gets the value of the creator property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreator() {
        if (creator == null) {
            return "";
        } else {
            return creator;
        }
    }

    /**
     * Sets the value of the creator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCreator(String value) {
        this.creator = value;
    }

    public boolean isSetCreator() {
        return (this.creator!= null);
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * Gets the value of the subject property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubject() {
        if (subject == null) {
            return "";
        } else {
            return subject;
        }
    }

    /**
     * Sets the value of the subject property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSubject(String value) {
        this.subject = value;
    }

    public boolean isSetSubject() {
        return (this.subject!= null);
    }

    /**
     * Gets the value of the contents property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getContents() {
        if (contents == null) {
            return "";
        } else {
            return contents;
        }
    }

    /**
     * Sets the value of the contents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setContents(String value) {
        this.contents = value;
    }

    public boolean isSetContents() {
        return (this.contents!= null);
    }

    /**
     * Gets the value of the intents property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIntents() {
        if (intents == null) {
            return "";
        } else {
            return intents;
        }
    }

    /**
     * Sets the value of the intents property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIntents(String value) {
        this.intents = value;
    }

    public boolean isSetIntents() {
        return (this.intents!= null);
    }

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * Gets the value of the color property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#4800FF";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

    /**
     * Gets the value of the opacity property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getOpacity() {
        if (opacity == null) {
            return  100;
        } else {
            return opacity;
        }
    }

    /**
     * Sets the value of the opacity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setOpacity(int value) {
        this.opacity = value;
    }

    public boolean isSetOpacity() {
        return (this.opacity!= null);
    }

    public void unsetOpacity() {
        this.opacity = null;
    }

    /**
     * Gets the value of the locked property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isLocked() {
        if (locked == null) {
            return true;
        } else {
            return locked;
        }
    }

    /**
     * Sets the value of the locked property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLocked(boolean value) {
        this.locked = value;
    }

    public boolean isSetLocked() {
        return (this.locked!= null);
    }

    public void unsetLocked() {
        this.locked = null;
    }

    /**
     * Gets the value of the printable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isPrintable() {
        if (printable == null) {
            return false;
        } else {
            return printable;
        }
    }

    /**
     * Sets the value of the printable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrintable(boolean value) {
        this.printable = value;
    }

    public boolean isSetPrintable() {
        return (this.printable!= null);
    }

    public void unsetPrintable() {
        this.printable = null;
    }

    /**
     * Gets the value of the rotatable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRotatable() {
        if (rotatable == null) {
            return true;
        } else {
            return rotatable;
        }
    }

    /**
     * Sets the value of the rotatable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRotatable(boolean value) {
        this.rotatable = value;
    }

    public boolean isSetRotatable() {
        return (this.rotatable!= null);
    }

    public void unsetRotatable() {
        this.rotatable = null;
    }

    /**
     * Gets the value of the viewable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isViewable() {
        if (viewable == null) {
            return true;
        } else {
            return viewable;
        }
    }

    /**
     * Sets the value of the viewable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setViewable(boolean value) {
        this.viewable = value;
    }

    public boolean isSetViewable() {
        return (this.viewable!= null);
    }

    public void unsetViewable() {
        this.viewable = null;
    }

    /**
     * Gets the value of the writable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isWritable() {
        if (writable == null) {
            return true;
        } else {
            return writable;
        }
    }

    /**
     * Sets the value of the writable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setWritable(boolean value) {
        this.writable = value;
    }

    public boolean isSetWritable() {
        return (this.writable!= null);
    }

    public void unsetWritable() {
        this.writable = null;
    }

    /**
     * Gets the value of the zoomable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isZoomable() {
        if (zoomable == null) {
            return true;
        } else {
            return zoomable;
        }
    }

    /**
     * Sets the value of the zoomable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setZoomable(boolean value) {
        this.zoomable = value;
    }

    public boolean isSetZoomable() {
        return (this.zoomable!= null);
    }

    public void unsetZoomable() {
        this.zoomable = null;
    }

    /**
     * Gets the value of the invisible property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isInvisible() {
        if (invisible == null) {
            return false;
        } else {
            return invisible;
        }
    }

    /**
     * Sets the value of the invisible property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInvisible(boolean value) {
        this.invisible = value;
    }

    public boolean isSetInvisible() {
        return (this.invisible!= null);
    }

    public void unsetInvisible() {
        this.invisible = null;
    }

    /**
     * Gets the value of the hidden property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHidden() {
        if (hidden == null) {
            return false;
        } else {
            return hidden;
        }
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHidden(boolean value) {
        this.hidden = value;
    }

    public boolean isSetHidden() {
        return (this.hidden!= null);
    }

    public void unsetHidden() {
        this.hidden = null;
    }

}
