
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ReplyStateType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="ReplyStateType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="accepted"/>
 *     <enumeration value="rejected"/>
 *     <enumeration value="cancelled"/>
 *     <enumeration value="completed"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ReplyStateType")
@XmlEnum
public enum ReplyStateType {

    @XmlEnumValue("accepted")
    ACCEPTED("accepted"),
    @XmlEnumValue("rejected")
    REJECTED("rejected"),
    @XmlEnumValue("cancelled")
    CANCELLED("cancelled"),
    @XmlEnumValue("completed")
    COMPLETED("completed"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    ReplyStateType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ReplyStateType fromValue(String v) {
        for (ReplyStateType c: ReplyStateType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
