
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PrintTraySelectionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PrintTraySelectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="readerDefault"/>
 *     <enumeration value="byPDFSize"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PrintTraySelectionType")
@XmlEnum
public enum PrintTraySelectionType {

    @XmlEnumValue("readerDefault")
    READER_DEFAULT("readerDefault"),
    @XmlEnumValue("byPDFSize")
    BY_PDF_SIZE("byPDFSize");
    private final String value;

    PrintTraySelectionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PrintTraySelectionType fromValue(String v) {
        for (PrintTraySelectionType c: PrintTraySelectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
