
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An element of this type shall contain information concerning the used encryption and the used encryption key.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for PasswordType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="PasswordType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="hasOpenPassword" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="hasPermissionPassword" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="hasAsymmetricEncryption" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="keyLength" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="keyAlgorithm" type="{http://schema.webpdf.de/1.0/extraction/info}KeyAlgorithmType" default="none" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PasswordType")
public class PasswordType {

    @XmlAttribute(name = "hasOpenPassword")
    protected Boolean hasOpenPassword;
    @XmlAttribute(name = "hasPermissionPassword")
    protected Boolean hasPermissionPassword;
    @XmlAttribute(name = "hasAsymmetricEncryption")
    protected Boolean hasAsymmetricEncryption;
    @XmlAttribute(name = "keyLength")
    protected Integer keyLength;
    @XmlAttribute(name = "keyAlgorithm")
    protected KeyAlgorithmType keyAlgorithm;

    /**
     * Gets the value of the hasOpenPassword property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHasOpenPassword() {
        if (hasOpenPassword == null) {
            return false;
        } else {
            return hasOpenPassword;
        }
    }

    /**
     * Sets the value of the hasOpenPassword property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHasOpenPassword(boolean value) {
        this.hasOpenPassword = value;
    }

    public boolean isSetHasOpenPassword() {
        return (this.hasOpenPassword!= null);
    }

    public void unsetHasOpenPassword() {
        this.hasOpenPassword = null;
    }

    /**
     * Gets the value of the hasPermissionPassword property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHasPermissionPassword() {
        if (hasPermissionPassword == null) {
            return false;
        } else {
            return hasPermissionPassword;
        }
    }

    /**
     * Sets the value of the hasPermissionPassword property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHasPermissionPassword(boolean value) {
        this.hasPermissionPassword = value;
    }

    public boolean isSetHasPermissionPassword() {
        return (this.hasPermissionPassword!= null);
    }

    public void unsetHasPermissionPassword() {
        this.hasPermissionPassword = null;
    }

    /**
     * Gets the value of the hasAsymmetricEncryption property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHasAsymmetricEncryption() {
        if (hasAsymmetricEncryption == null) {
            return false;
        } else {
            return hasAsymmetricEncryption;
        }
    }

    /**
     * Sets the value of the hasAsymmetricEncryption property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHasAsymmetricEncryption(boolean value) {
        this.hasAsymmetricEncryption = value;
    }

    public boolean isSetHasAsymmetricEncryption() {
        return (this.hasAsymmetricEncryption!= null);
    }

    public void unsetHasAsymmetricEncryption() {
        this.hasAsymmetricEncryption = null;
    }

    /**
     * Gets the value of the keyLength property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getKeyLength() {
        if (keyLength == null) {
            return  0;
        } else {
            return keyLength;
        }
    }

    /**
     * Sets the value of the keyLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setKeyLength(int value) {
        this.keyLength = value;
    }

    public boolean isSetKeyLength() {
        return (this.keyLength!= null);
    }

    public void unsetKeyLength() {
        this.keyLength = null;
    }

    /**
     * Gets the value of the keyAlgorithm property.
     * 
     * @return
     *     possible object is
     *     {@link KeyAlgorithmType }
     *     
     */
    public KeyAlgorithmType getKeyAlgorithm() {
        if (keyAlgorithm == null) {
            return KeyAlgorithmType.NONE;
        } else {
            return keyAlgorithm;
        }
    }

    /**
     * Sets the value of the keyAlgorithm property.
     * 
     * @param value
     *     allowed object is
     *     {@link KeyAlgorithmType }
     *     
     */
    public void setKeyAlgorithm(KeyAlgorithmType value) {
        this.keyAlgorithm = value;
    }

    public boolean isSetKeyAlgorithm() {
        return (this.keyAlgorithm!= null);
    }

}
