
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for MagnificationType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="MagnificationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="fitWidth"/>
 *     <enumeration value="fitVisible"/>
 *     <enumeration value="fitHeight"/>
 *     <enumeration value="fitPage"/>
 *     <enumeration value="fitActual"/>
 *     <enumeration value="zoom"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "MagnificationType")
@XmlEnum
public enum MagnificationType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("fitWidth")
    FIT_WIDTH("fitWidth"),
    @XmlEnumValue("fitVisible")
    FIT_VISIBLE("fitVisible"),
    @XmlEnumValue("fitHeight")
    FIT_HEIGHT("fitHeight"),
    @XmlEnumValue("fitPage")
    FIT_PAGE("fitPage"),
    @XmlEnumValue("fitActual")
    FIT_ACTUAL("fitActual"),
    @XmlEnumValue("zoom")
    ZOOM("zoom");
    private final String value;

    MagnificationType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MagnificationType fromValue(String v) {
        for (MagnificationType c: MagnificationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
