
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for KeyAlgorithmType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="KeyAlgorithmType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="aes"/>
 *     <enumeration value="rc4"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "KeyAlgorithmType")
@XmlEnum
public enum KeyAlgorithmType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("aes")
    AES("aes"),
    @XmlEnumValue("rc4")
    RC_4("rc4");
    private final String value;

    KeyAlgorithmType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static KeyAlgorithmType fromValue(String v) {
        for (KeyAlgorithmType c: KeyAlgorithmType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
