
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FormsFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="FormsFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="acroForm"/>
 *     <enumeration value="staticXFA"/>
 *     <enumeration value="dynamicXFA"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FormsFormatType")
@XmlEnum
public enum FormsFormatType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("acroForm")
    ACRO_FORM("acroForm"),
    @XmlEnumValue("staticXFA")
    STATIC_XFA("staticXFA"),
    @XmlEnumValue("dynamicXFA")
    DYNAMIC_XFA("dynamicXFA");
    private final String value;

    FormsFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FormsFormatType fromValue(String v) {
        for (FormsFormatType c: FormsFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
