
package net.webpdf.wsclient.schema.extraction.info;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A document element that describes the content and properties of the PDF document as metadata.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for document element declaration.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <element name="document">
 *   <complexType>
 *     <complexContent>
 *       <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *         <sequence>
 *           <element name="information" type="{http://schema.webpdf.de/1.0/extraction/info}InformationType"/>
 *           <element name="security" type="{http://schema.webpdf.de/1.0/extraction/info}SecurityType"/>
 *           <element name="attachments" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <sequence>
 *                     <element name="attachment" type="{http://schema.webpdf.de/1.0/extraction/info}AttachmentType" maxOccurs="unbounded" minOccurs="0"/>
 *                   </sequence>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="pages" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <sequence>
 *                     <element name="page" maxOccurs="unbounded" minOccurs="0">
 *                       <complexType>
 *                         <complexContent>
 *                           <extension base="{http://schema.webpdf.de/1.0/extraction/info}PageType">
 *                             <sequence>
 *                               <element name="boxes" type="{http://schema.webpdf.de/1.0/extraction/info}BoxesType"/>
 *                             </sequence>
 *                           </extension>
 *                         </complexContent>
 *                       </complexType>
 *                     </element>
 *                   </sequence>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="form" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <sequence>
 *                     <element name="field" type="{http://schema.webpdf.de/1.0/extraction/info}FieldType" maxOccurs="unbounded" minOccurs="0"/>
 *                   </sequence>
 *                   <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                   <attribute name="formType" type="{http://schema.webpdf.de/1.0/extraction/info}FormsFormatType" default="none" />
 *                   <attribute name="defaultAppearance" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                   <attribute name="needAppearances" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="annotations" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="annotation" type="{http://schema.webpdf.de/1.0/extraction/info}AnnotationType"/>
 *                   </choice>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="signatures" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="signature" type="{http://schema.webpdf.de/1.0/extraction/info}SignatureType"/>
 *                   </choice>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="backgrounds" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="background" type="{http://schema.webpdf.de/1.0/extraction/info}BackgroundContentType"/>
 *                   </choice>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="headersFooters" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="headerFooter" type="{http://schema.webpdf.de/1.0/extraction/info}HeaderFooterType"/>
 *                   </choice>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="transitions" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="transition" type="{http://schema.webpdf.de/1.0/extraction/info}TransitionType"/>
 *                   </choice>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="images" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="image" type="{http://schema.webpdf.de/1.0/extraction/info}ImageType"/>
 *                   </choice>
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *           <element name="folders" minOccurs="0">
 *             <complexType>
 *               <complexContent>
 *                 <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   <sequence maxOccurs="unbounded" minOccurs="0">
 *                     <element name="folder" type="{http://schema.webpdf.de/1.0/extraction/info}FolderType"/>
 *                   </sequence>
 *                   <attribute name="initialFile" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 </restriction>
 *               </complexContent>
 *             </complexType>
 *           </element>
 *         </sequence>
 *       </restriction>
 *     </complexContent>
 *   </complexType>
 * </element>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "information",
    "security",
    "attachments",
    "pages",
    "form",
    "annotations",
    "signatures",
    "backgrounds",
    "headersFooters",
    "transitions",
    "images",
    "folders"
})
@XmlRootElement(name = "document")
public class DocumentType {

    @XmlElement(required = true)
    protected InformationType information;
    @XmlElement(required = true)
    protected SecurityType security;
    protected DocumentType.Attachments attachments;
    protected DocumentType.Pages pages;
    protected DocumentType.Form form;
    protected DocumentType.Annotations annotations;
    protected DocumentType.Signatures signatures;
    protected DocumentType.Backgrounds backgrounds;
    protected DocumentType.HeadersFooters headersFooters;
    protected DocumentType.Transitions transitions;
    protected DocumentType.Images images;
    protected DocumentType.Folders folders;

    /**
     * Gets the value of the information property.
     * 
     * @return
     *     possible object is
     *     {@link InformationType }
     *     
     */
    public InformationType getInformation() {
        return information;
    }

    /**
     * Sets the value of the information property.
     * 
     * @param value
     *     allowed object is
     *     {@link InformationType }
     *     
     */
    public void setInformation(InformationType value) {
        this.information = value;
    }

    public boolean isSetInformation() {
        return (this.information!= null);
    }

    /**
     * Gets the value of the security property.
     * 
     * @return
     *     possible object is
     *     {@link SecurityType }
     *     
     */
    public SecurityType getSecurity() {
        return security;
    }

    /**
     * Sets the value of the security property.
     * 
     * @param value
     *     allowed object is
     *     {@link SecurityType }
     *     
     */
    public void setSecurity(SecurityType value) {
        this.security = value;
    }

    public boolean isSetSecurity() {
        return (this.security!= null);
    }

    /**
     * Gets the value of the attachments property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Attachments }
     *     
     */
    public DocumentType.Attachments getAttachments() {
        return attachments;
    }

    /**
     * Sets the value of the attachments property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Attachments }
     *     
     */
    public void setAttachments(DocumentType.Attachments value) {
        this.attachments = value;
    }

    public boolean isSetAttachments() {
        return (this.attachments!= null);
    }

    /**
     * Gets the value of the pages property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Pages }
     *     
     */
    public DocumentType.Pages getPages() {
        return pages;
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Pages }
     *     
     */
    public void setPages(DocumentType.Pages value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * Gets the value of the form property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Form }
     *     
     */
    public DocumentType.Form getForm() {
        return form;
    }

    /**
     * Sets the value of the form property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Form }
     *     
     */
    public void setForm(DocumentType.Form value) {
        this.form = value;
    }

    public boolean isSetForm() {
        return (this.form!= null);
    }

    /**
     * Gets the value of the annotations property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Annotations }
     *     
     */
    public DocumentType.Annotations getAnnotations() {
        return annotations;
    }

    /**
     * Sets the value of the annotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Annotations }
     *     
     */
    public void setAnnotations(DocumentType.Annotations value) {
        this.annotations = value;
    }

    public boolean isSetAnnotations() {
        return (this.annotations!= null);
    }

    /**
     * Gets the value of the signatures property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Signatures }
     *     
     */
    public DocumentType.Signatures getSignatures() {
        return signatures;
    }

    /**
     * Sets the value of the signatures property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Signatures }
     *     
     */
    public void setSignatures(DocumentType.Signatures value) {
        this.signatures = value;
    }

    public boolean isSetSignatures() {
        return (this.signatures!= null);
    }

    /**
     * Gets the value of the backgrounds property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Backgrounds }
     *     
     */
    public DocumentType.Backgrounds getBackgrounds() {
        return backgrounds;
    }

    /**
     * Sets the value of the backgrounds property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Backgrounds }
     *     
     */
    public void setBackgrounds(DocumentType.Backgrounds value) {
        this.backgrounds = value;
    }

    public boolean isSetBackgrounds() {
        return (this.backgrounds!= null);
    }

    /**
     * Gets the value of the headersFooters property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.HeadersFooters }
     *     
     */
    public DocumentType.HeadersFooters getHeadersFooters() {
        return headersFooters;
    }

    /**
     * Sets the value of the headersFooters property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.HeadersFooters }
     *     
     */
    public void setHeadersFooters(DocumentType.HeadersFooters value) {
        this.headersFooters = value;
    }

    public boolean isSetHeadersFooters() {
        return (this.headersFooters!= null);
    }

    /**
     * Gets the value of the transitions property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Transitions }
     *     
     */
    public DocumentType.Transitions getTransitions() {
        return transitions;
    }

    /**
     * Sets the value of the transitions property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Transitions }
     *     
     */
    public void setTransitions(DocumentType.Transitions value) {
        this.transitions = value;
    }

    public boolean isSetTransitions() {
        return (this.transitions!= null);
    }

    /**
     * Gets the value of the images property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Images }
     *     
     */
    public DocumentType.Images getImages() {
        return images;
    }

    /**
     * Sets the value of the images property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Images }
     *     
     */
    public void setImages(DocumentType.Images value) {
        this.images = value;
    }

    public boolean isSetImages() {
        return (this.images!= null);
    }

    /**
     * Gets the value of the folders property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentType.Folders }
     *     
     */
    public DocumentType.Folders getFolders() {
        return folders;
    }

    /**
     * Sets the value of the folders property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentType.Folders }
     *     
     */
    public void setFolders(DocumentType.Folders value) {
        this.folders = value;
    }

    public boolean isSetFolders() {
        return (this.folders!= null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="annotation" type="{http://schema.webpdf.de/1.0/extraction/info}AnnotationType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "annotation"
    })
    public static class Annotations {

        protected List<AnnotationType> annotation;

        /**
         * Gets the value of the annotation property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the annotation property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAnnotation().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link AnnotationType }
         * 
         * 
         * @return
         *     The value of the annotation property.
         */
        public List<AnnotationType> getAnnotation() {
            if (annotation == null) {
                annotation = new ArrayList<>();
            }
            return this.annotation;
        }

        public boolean isSetAnnotation() {
            return ((this.annotation!= null)&&(!this.annotation.isEmpty()));
        }

        public void unsetAnnotation() {
            this.annotation = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence>
     *         <element name="attachment" type="{http://schema.webpdf.de/1.0/extraction/info}AttachmentType" maxOccurs="unbounded" minOccurs="0"/>
     *       </sequence>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "attachment"
    })
    public static class Attachments {

        protected List<AttachmentType> attachment;

        /**
         * Gets the value of the attachment property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the attachment property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAttachment().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link AttachmentType }
         * 
         * 
         * @return
         *     The value of the attachment property.
         */
        public List<AttachmentType> getAttachment() {
            if (attachment == null) {
                attachment = new ArrayList<>();
            }
            return this.attachment;
        }

        public boolean isSetAttachment() {
            return ((this.attachment!= null)&&(!this.attachment.isEmpty()));
        }

        public void unsetAttachment() {
            this.attachment = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="background" type="{http://schema.webpdf.de/1.0/extraction/info}BackgroundContentType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "background"
    })
    public static class Backgrounds {

        protected List<BackgroundContentType> background;

        /**
         * Gets the value of the background property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the background property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getBackground().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link BackgroundContentType }
         * 
         * 
         * @return
         *     The value of the background property.
         */
        public List<BackgroundContentType> getBackground() {
            if (background == null) {
                background = new ArrayList<>();
            }
            return this.background;
        }

        public boolean isSetBackground() {
            return ((this.background!= null)&&(!this.background.isEmpty()));
        }

        public void unsetBackground() {
            this.background = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence maxOccurs="unbounded" minOccurs="0">
     *         <element name="folder" type="{http://schema.webpdf.de/1.0/extraction/info}FolderType"/>
     *       </sequence>
     *       <attribute name="initialFile" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "folder"
    })
    public static class Folders {

        protected List<FolderType> folder;
        @XmlAttribute(name = "initialFile")
        protected String initialFile;

        /**
         * Gets the value of the folder property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the folder property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getFolder().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link FolderType }
         * 
         * 
         * @return
         *     The value of the folder property.
         */
        public List<FolderType> getFolder() {
            if (folder == null) {
                folder = new ArrayList<>();
            }
            return this.folder;
        }

        public boolean isSetFolder() {
            return ((this.folder!= null)&&(!this.folder.isEmpty()));
        }

        public void unsetFolder() {
            this.folder = null;
        }

        /**
         * Gets the value of the initialFile property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getInitialFile() {
            if (initialFile == null) {
                return "";
            } else {
                return initialFile;
            }
        }

        /**
         * Sets the value of the initialFile property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setInitialFile(String value) {
            this.initialFile = value;
        }

        public boolean isSetInitialFile() {
            return (this.initialFile!= null);
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence>
     *         <element name="field" type="{http://schema.webpdf.de/1.0/extraction/info}FieldType" maxOccurs="unbounded" minOccurs="0"/>
     *       </sequence>
     *       <attribute name="objectKey" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="formType" type="{http://schema.webpdf.de/1.0/extraction/info}FormsFormatType" default="none" />
     *       <attribute name="defaultAppearance" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="needAppearances" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "field"
    })
    public static class Form {

        protected List<FieldType> field;
        @XmlAttribute(name = "objectKey")
        protected String objectKey;
        @XmlAttribute(name = "formType")
        protected FormsFormatType formType;
        @XmlAttribute(name = "defaultAppearance")
        protected String defaultAppearance;
        @XmlAttribute(name = "needAppearances")
        protected Boolean needAppearances;

        /**
         * Gets the value of the field property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the field property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getField().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link FieldType }
         * 
         * 
         * @return
         *     The value of the field property.
         */
        public List<FieldType> getField() {
            if (field == null) {
                field = new ArrayList<>();
            }
            return this.field;
        }

        public boolean isSetField() {
            return ((this.field!= null)&&(!this.field.isEmpty()));
        }

        public void unsetField() {
            this.field = null;
        }

        /**
         * Gets the value of the objectKey property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getObjectKey() {
            if (objectKey == null) {
                return "";
            } else {
                return objectKey;
            }
        }

        /**
         * Sets the value of the objectKey property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setObjectKey(String value) {
            this.objectKey = value;
        }

        public boolean isSetObjectKey() {
            return (this.objectKey!= null);
        }

        /**
         * Gets the value of the formType property.
         * 
         * @return
         *     possible object is
         *     {@link FormsFormatType }
         *     
         */
        public FormsFormatType getFormType() {
            if (formType == null) {
                return FormsFormatType.NONE;
            } else {
                return formType;
            }
        }

        /**
         * Sets the value of the formType property.
         * 
         * @param value
         *     allowed object is
         *     {@link FormsFormatType }
         *     
         */
        public void setFormType(FormsFormatType value) {
            this.formType = value;
        }

        public boolean isSetFormType() {
            return (this.formType!= null);
        }

        /**
         * Gets the value of the defaultAppearance property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getDefaultAppearance() {
            if (defaultAppearance == null) {
                return "";
            } else {
                return defaultAppearance;
            }
        }

        /**
         * Sets the value of the defaultAppearance property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setDefaultAppearance(String value) {
            this.defaultAppearance = value;
        }

        public boolean isSetDefaultAppearance() {
            return (this.defaultAppearance!= null);
        }

        /**
         * Gets the value of the needAppearances property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isNeedAppearances() {
            if (needAppearances == null) {
                return false;
            } else {
                return needAppearances;
            }
        }

        /**
         * Sets the value of the needAppearances property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setNeedAppearances(boolean value) {
            this.needAppearances = value;
        }

        public boolean isSetNeedAppearances() {
            return (this.needAppearances!= null);
        }

        public void unsetNeedAppearances() {
            this.needAppearances = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="headerFooter" type="{http://schema.webpdf.de/1.0/extraction/info}HeaderFooterType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "headerFooter"
    })
    public static class HeadersFooters {

        protected List<HeaderFooterType> headerFooter;

        /**
         * Gets the value of the headerFooter property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the headerFooter property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getHeaderFooter().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link HeaderFooterType }
         * 
         * 
         * @return
         *     The value of the headerFooter property.
         */
        public List<HeaderFooterType> getHeaderFooter() {
            if (headerFooter == null) {
                headerFooter = new ArrayList<>();
            }
            return this.headerFooter;
        }

        public boolean isSetHeaderFooter() {
            return ((this.headerFooter!= null)&&(!this.headerFooter.isEmpty()));
        }

        public void unsetHeaderFooter() {
            this.headerFooter = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="image" type="{http://schema.webpdf.de/1.0/extraction/info}ImageType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "image"
    })
    public static class Images {

        protected List<ImageType> image;

        /**
         * Gets the value of the image property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the image property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getImage().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link ImageType }
         * 
         * 
         * @return
         *     The value of the image property.
         */
        public List<ImageType> getImage() {
            if (image == null) {
                image = new ArrayList<>();
            }
            return this.image;
        }

        public boolean isSetImage() {
            return ((this.image!= null)&&(!this.image.isEmpty()));
        }

        public void unsetImage() {
            this.image = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence>
     *         <element name="page" maxOccurs="unbounded" minOccurs="0">
     *           <complexType>
     *             <complexContent>
     *               <extension base="{http://schema.webpdf.de/1.0/extraction/info}PageType">
     *                 <sequence>
     *                   <element name="boxes" type="{http://schema.webpdf.de/1.0/extraction/info}BoxesType"/>
     *                 </sequence>
     *               </extension>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </sequence>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "page"
    })
    public static class Pages {

        protected List<DocumentType.Pages.Page> page;

        /**
         * Gets the value of the page property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the page property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getPage().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link DocumentType.Pages.Page }
         * 
         * 
         * @return
         *     The value of the page property.
         */
        public List<DocumentType.Pages.Page> getPage() {
            if (page == null) {
                page = new ArrayList<>();
            }
            return this.page;
        }

        public boolean isSetPage() {
            return ((this.page!= null)&&(!this.page.isEmpty()));
        }

        public void unsetPage() {
            this.page = null;
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <extension base="{http://schema.webpdf.de/1.0/extraction/info}PageType">
         *       <sequence>
         *         <element name="boxes" type="{http://schema.webpdf.de/1.0/extraction/info}BoxesType"/>
         *       </sequence>
         *     </extension>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "boxes"
        })
        public static class Page
            extends PageType
        {

            @XmlElement(required = true)
            protected BoxesType boxes;

            /**
             * Gets the value of the boxes property.
             * 
             * @return
             *     possible object is
             *     {@link BoxesType }
             *     
             */
            public BoxesType getBoxes() {
                return boxes;
            }

            /**
             * Sets the value of the boxes property.
             * 
             * @param value
             *     allowed object is
             *     {@link BoxesType }
             *     
             */
            public void setBoxes(BoxesType value) {
                this.boxes = value;
            }

            public boolean isSetBoxes() {
                return (this.boxes!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="signature" type="{http://schema.webpdf.de/1.0/extraction/info}SignatureType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "signature"
    })
    public static class Signatures {

        protected List<SignatureType> signature;

        /**
         * Gets the value of the signature property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the signature property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getSignature().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link SignatureType }
         * 
         * 
         * @return
         *     The value of the signature property.
         */
        public List<SignatureType> getSignature() {
            if (signature == null) {
                signature = new ArrayList<>();
            }
            return this.signature;
        }

        public boolean isSetSignature() {
            return ((this.signature!= null)&&(!this.signature.isEmpty()));
        }

        public void unsetSignature() {
            this.signature = null;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="transition" type="{http://schema.webpdf.de/1.0/extraction/info}TransitionType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "transition"
    })
    public static class Transitions {

        protected List<TransitionType> transition;

        /**
         * Gets the value of the transition property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the transition property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getTransition().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link TransitionType }
         * 
         * 
         * @return
         *     The value of the transition property.
         */
        public List<TransitionType> getTransition() {
            if (transition == null) {
                transition = new ArrayList<>();
            }
            return this.transition;
        }

        public boolean isSetTransition() {
            return ((this.transition!= null)&&(!this.transition.isEmpty()));
        }

        public void unsetTransition() {
            this.transition = null;
        }

    }

}
