/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Stores detailed information about a single session entry in the session table.
 */
@Schema(description = "Stores detailed information about a single session entry in the session table.")
@JsonPropertyOrder({
  SessionTableEntry.JSON_PROPERTY_ADMIN,
  SessionTableEntry.JSON_PROPERTY_FILE_COUNT,
  SessionTableEntry.JSON_PROPERTY_FILE_FOLDER,
  SessionTableEntry.JSON_PROPERTY_FILE_SIZE,
  SessionTableEntry.JSON_PROPERTY_FILE_SIZE_HISTORY,
  SessionTableEntry.JSON_PROPERTY_IS_ADMIN,
  SessionTableEntry.JSON_PROPERTY_LAST_ACCESS,
  SessionTableEntry.JSON_PROPERTY_PROVIDER_ID,
  SessionTableEntry.JSON_PROPERTY_SESSION_EXPIRATION,
  SessionTableEntry.JSON_PROPERTY_SESSION_ID,
  SessionTableEntry.JSON_PROPERTY_SESSION_STATE,
  SessionTableEntry.JSON_PROPERTY_USER_NAME
})
@JsonTypeName("Session_TableEntry")

public class SessionTableEntry {
  public static final String JSON_PROPERTY_ADMIN = "admin";
  private Boolean admin = false;

  public static final String JSON_PROPERTY_FILE_COUNT = "fileCount";
  private Long fileCount = 0l;

  public static final String JSON_PROPERTY_FILE_FOLDER = "fileFolder";
  private String fileFolder = "";

  public static final String JSON_PROPERTY_FILE_SIZE = "fileSize";
  private Long fileSize = 0l;

  public static final String JSON_PROPERTY_FILE_SIZE_HISTORY = "fileSizeHistory";
  private Long fileSizeHistory = 0l;

  public static final String JSON_PROPERTY_IS_ADMIN = "isAdmin";
  private Boolean isAdmin = false;

  public static final String JSON_PROPERTY_LAST_ACCESS = "lastAccess";
  private Long lastAccess = 0l;

  public static final String JSON_PROPERTY_PROVIDER_ID = "providerId";
  private String providerId = "";

  public static final String JSON_PROPERTY_SESSION_EXPIRATION = "sessionExpiration";
  private Long sessionExpiration = 0l;

  public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
  private String sessionId = "";

  public static final String JSON_PROPERTY_SESSION_STATE = "sessionState";
  private SessionState sessionState = SessionState.UNKNOWN;

  public static final String JSON_PROPERTY_USER_NAME = "userName";
  private String userName = "";

  public SessionTableEntry() {
  }

  public SessionTableEntry admin(Boolean admin) {
    
    this.admin = admin;
    return this;
  }

  /**
   * Get admin
   * @return admin
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAdmin() {
    return admin;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin(Boolean admin) {
    this.admin = admin;
  }


  public SessionTableEntry fileCount(Long fileCount) {
    
    this.fileCount = fileCount;
    return this;
  }

  /**
   * Number of files saved in the session.
   * @return fileCount
   **/
  @Nullable
  @Schema(name = "Number of files saved in the session.")
  @JsonProperty(JSON_PROPERTY_FILE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFileCount() {
    return fileCount;
  }


  @JsonProperty(JSON_PROPERTY_FILE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileCount(Long fileCount) {
    this.fileCount = fileCount;
  }


  public SessionTableEntry fileFolder(String fileFolder) {
    
    this.fileFolder = fileFolder;
    return this;
  }

  /**
   * Unique name of the session storage folder.
   * @return fileFolder
   **/
  @Nullable
  @Schema(name = "Unique name of the session storage folder.")
  @JsonProperty(JSON_PROPERTY_FILE_FOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileFolder() {
    return fileFolder;
  }


  @JsonProperty(JSON_PROPERTY_FILE_FOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileFolder(String fileFolder) {
    this.fileFolder = fileFolder;
  }


  public SessionTableEntry fileSize(Long fileSize) {
    
    this.fileSize = fileSize;
    return this;
  }

  /**
   * Total size in bytes of all files saved in the session, excluding history entries.
   * @return fileSize
   **/
  @Nullable
  @Schema(name = "Total size in bytes of all files saved in the session, excluding history entries.")
  @JsonProperty(JSON_PROPERTY_FILE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFileSize() {
    return fileSize;
  }


  @JsonProperty(JSON_PROPERTY_FILE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }


  public SessionTableEntry fileSizeHistory(Long fileSizeHistory) {
    
    this.fileSizeHistory = fileSizeHistory;
    return this;
  }

  /**
   * Total size in bytes of all history files stored in the session, except the active file entry.
   * @return fileSizeHistory
   **/
  @Nullable
  @Schema(name = "Total size in bytes of all history files stored in the session, except the active file entry.")
  @JsonProperty(JSON_PROPERTY_FILE_SIZE_HISTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFileSizeHistory() {
    return fileSizeHistory;
  }


  @JsonProperty(JSON_PROPERTY_FILE_SIZE_HISTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileSizeHistory(Long fileSizeHistory) {
    this.fileSizeHistory = fileSizeHistory;
  }


  public SessionTableEntry isAdmin(Boolean isAdmin) {
    
    this.isAdmin = isAdmin;
    return this;
  }

  /**
   * Set if the user has administrator rights.
   * @return isAdmin
   **/
  @Nullable
  @Schema(name = "Set if the user has administrator rights.")
  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsAdmin() {
    return isAdmin;
  }


  @JsonProperty(JSON_PROPERTY_IS_ADMIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsAdmin(Boolean isAdmin) {
    this.isAdmin = isAdmin;
  }


  public SessionTableEntry lastAccess(Long lastAccess) {
    
    this.lastAccess = lastAccess;
    return this;
  }

  /**
   * UTC time of the last access to the session.
   * @return lastAccess
   **/
  @Nullable
  @Schema(name = "UTC time of the last access to the session.")
  @JsonProperty(JSON_PROPERTY_LAST_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getLastAccess() {
    return lastAccess;
  }


  @JsonProperty(JSON_PROPERTY_LAST_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastAccess(Long lastAccess) {
    this.lastAccess = lastAccess;
  }


  public SessionTableEntry providerId(String providerId) {
    
    this.providerId = providerId;
    return this;
  }

  /**
   * The ID of the external credential provider used to create the session. Empty if local provider was used.
   * @return providerId
   **/
  @Nullable
  @Schema(name = "The ID of the external credential provider used to create the session. Empty if local provider was used.")
  @JsonProperty(JSON_PROPERTY_PROVIDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProviderId() {
    return providerId;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProviderId(String providerId) {
    this.providerId = providerId;
  }


  public SessionTableEntry sessionExpiration(Long sessionExpiration) {
    
    this.sessionExpiration = sessionExpiration;
    return this;
  }

  /**
   * Time in seconds when the session will expire.
   * @return sessionExpiration
   **/
  @Nullable
  @Schema(name = "Time in seconds when the session will expire.")
  @JsonProperty(JSON_PROPERTY_SESSION_EXPIRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSessionExpiration() {
    return sessionExpiration;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_EXPIRATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionExpiration(Long sessionExpiration) {
    this.sessionExpiration = sessionExpiration;
  }


  public SessionTableEntry sessionId(String sessionId) {
    
    this.sessionId = sessionId;
    return this;
  }

  /**
   * Unique id of the session.
   * @return sessionId
   **/
  @Nullable
  @Schema(name = "Unique id of the session.")
  @JsonProperty(JSON_PROPERTY_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSessionId() {
    return sessionId;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }


  public SessionTableEntry sessionState(SessionState sessionState) {
    
    this.sessionState = sessionState;
    return this;
  }

  /**
   * Get sessionState
   * @return sessionState
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SESSION_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SessionState getSessionState() {
    return sessionState;
  }


  @JsonProperty(JSON_PROPERTY_SESSION_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSessionState(SessionState sessionState) {
    this.sessionState = sessionState;
  }


  public SessionTableEntry userName(String userName) {
    
    this.userName = userName;
    return this;
  }

  /**
   * Username of the authenticated user or empty if unknown or it is an anonymous session.
   * @return userName
   **/
  @Nullable
  @Schema(name = "Username of the authenticated user or empty if unknown or it is an anonymous session.")
  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserName() {
    return userName;
  }


  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserName(String userName) {
    this.userName = userName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SessionTableEntry sessionTableEntry = (SessionTableEntry) o;
    return Objects.equals(this.admin, sessionTableEntry.admin) &&
        Objects.equals(this.fileCount, sessionTableEntry.fileCount) &&
        Objects.equals(this.fileFolder, sessionTableEntry.fileFolder) &&
        Objects.equals(this.fileSize, sessionTableEntry.fileSize) &&
        Objects.equals(this.fileSizeHistory, sessionTableEntry.fileSizeHistory) &&
        Objects.equals(this.isAdmin, sessionTableEntry.isAdmin) &&
        Objects.equals(this.lastAccess, sessionTableEntry.lastAccess) &&
        Objects.equals(this.providerId, sessionTableEntry.providerId) &&
        Objects.equals(this.sessionExpiration, sessionTableEntry.sessionExpiration) &&
        Objects.equals(this.sessionId, sessionTableEntry.sessionId) &&
        Objects.equals(this.sessionState, sessionTableEntry.sessionState) &&
        Objects.equals(this.userName, sessionTableEntry.userName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(admin, fileCount, fileFolder, fileSize, fileSizeHistory, isAdmin, lastAccess, providerId, sessionExpiration, sessionId, sessionState, userName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SessionTableEntry {\n");
    sb.append("    admin: ").append(toIndentedString(admin)).append("\n");
    sb.append("    fileCount: ").append(toIndentedString(fileCount)).append("\n");
    sb.append("    fileFolder: ").append(toIndentedString(fileFolder)).append("\n");
    sb.append("    fileSize: ").append(toIndentedString(fileSize)).append("\n");
    sb.append("    fileSizeHistory: ").append(toIndentedString(fileSizeHistory)).append("\n");
    sb.append("    isAdmin: ").append(toIndentedString(isAdmin)).append("\n");
    sb.append("    lastAccess: ").append(toIndentedString(lastAccess)).append("\n");
    sb.append("    providerId: ").append(toIndentedString(providerId)).append("\n");
    sb.append("    sessionExpiration: ").append(toIndentedString(sessionExpiration)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    sessionState: ").append(toIndentedString(sessionState)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
