/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The print operation element can be used to print documents.
 */
@Schema(description = "The print operation element can be used to print documents.")
@JsonPropertyOrder({
  OperationToolboxPrintPrint.JSON_PROPERTY_AUTO_ROTATE,
  OperationToolboxPrintPrint.JSON_PROPERTY_CENTER_IN_PAGE,
  OperationToolboxPrintPrint.JSON_PROPERTY_COPIES,
  OperationToolboxPrintPrint.JSON_PROPERTY_DPI,
  OperationToolboxPrintPrint.JSON_PROPERTY_EXPAND_TO_MARGINS,
  OperationToolboxPrintPrint.JSON_PROPERTY_JOB_NAME,
  OperationToolboxPrintPrint.JSON_PROPERTY_MODE,
  OperationToolboxPrintPrint.JSON_PROPERTY_PAGES,
  OperationToolboxPrintPrint.JSON_PROPERTY_PRINTER_NAME,
  OperationToolboxPrintPrint.JSON_PROPERTY_SHRINK_TO_MARGINS
})
@JsonTypeName("Operation_ToolboxPrint_print")

public class OperationToolboxPrintPrint {
  public static final String JSON_PROPERTY_AUTO_ROTATE = "autoRotate";
  private Boolean autoRotate = true;

  public static final String JSON_PROPERTY_CENTER_IN_PAGE = "centerInPage";
  private Boolean centerInPage = false;

  public static final String JSON_PROPERTY_COPIES = "copies";
  private Integer copies = 1;

  public static final String JSON_PROPERTY_DPI = "dpi";
  private Integer dpi = 0;

  public static final String JSON_PROPERTY_EXPAND_TO_MARGINS = "expandToMargins";
  private Boolean expandToMargins = false;

  public static final String JSON_PROPERTY_JOB_NAME = "jobName";
  private String jobName = "webPDF Print Job";

  /**
   * Select the printing mode, that shall be used.  *   default &#x3D; The drawing operations are applied to the printout as defined in the PDF document. *   image &#x3D; Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result. *   raster &#x3D; Every page of the document is rastered before printing. This is a compatibility mode for older printers.
   */
  public enum ModeEnum {
    DEFAULT("default"),
    
    RASTER("raster"),
    
    IMAGE("image");

    private String value;

    ModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ModeEnum fromValue(String value) {
      for (ModeEnum b : ModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MODE = "mode";
  private ModeEnum mode = ModeEnum.DEFAULT;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public static final String JSON_PROPERTY_PRINTER_NAME = "printerName";
  private String printerName = "";

  public static final String JSON_PROPERTY_SHRINK_TO_MARGINS = "shrinkToMargins";
  private Boolean shrinkToMargins = false;

  public OperationToolboxPrintPrint() {
  }

  public OperationToolboxPrintPrint autoRotate(Boolean autoRotate) {
    
    this.autoRotate = autoRotate;
    return this;
  }

  /**
   * If \&quot;true,\&quot; the PDF document&#39;s orientation will be automatically adjusted in line with the printer&#39;s configured paper orientation.
   * @return autoRotate
   **/
  @Nullable
  @Schema(name = "If \"true,\" the PDF document's orientation will be automatically adjusted in line with the printer's configured paper orientation.")
  @JsonProperty(JSON_PROPERTY_AUTO_ROTATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutoRotate() {
    return autoRotate;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_ROTATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoRotate(Boolean autoRotate) {
    this.autoRotate = autoRotate;
  }


  public OperationToolboxPrintPrint centerInPage(Boolean centerInPage) {
    
    this.centerInPage = centerInPage;
    return this;
  }

  /**
   * If \&quot;true\&quot;, the PDF page will be centered in the middle of the paper.
   * @return centerInPage
   **/
  @Nullable
  @Schema(name = "If \"true\", the PDF page will be centered in the middle of the paper.")
  @JsonProperty(JSON_PROPERTY_CENTER_IN_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCenterInPage() {
    return centerInPage;
  }


  @JsonProperty(JSON_PROPERTY_CENTER_IN_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCenterInPage(Boolean centerInPage) {
    this.centerInPage = centerInPage;
  }


  public OperationToolboxPrintPrint copies(Integer copies) {
    
    this.copies = copies;
    return this;
  }

  /**
   * Defines the number of copies that should be printed.
   * minimum: 1
   * @return copies
   **/
  @Nullable
  @Schema(name = "Defines the number of copies that should be printed.")
  @JsonProperty(JSON_PROPERTY_COPIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCopies() {
    return copies;
  }


  @JsonProperty(JSON_PROPERTY_COPIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCopies(Integer copies) {
    this.copies = copies;
  }


  public OperationToolboxPrintPrint dpi(Integer dpi) {
    
    this.dpi = dpi;
    return this;
  }

  /**
   * Sets the printer resolution for the \&quot;image\&quot; print mode. If this value is set to 0, the document will be printed, using a resolution suggested by the printer. (High resolutions will lead to better quality results, but will tremendously increase the required time and resources.)
   * @return dpi
   **/
  @Nullable
  @Schema(name = "Sets the printer resolution for the \"image\" print mode. If this value is set to 0, the document will be printed, using a resolution suggested by the printer. (High resolutions will lead to better quality results, but will tremendously increase the required time and resources.)")
  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDpi() {
    return dpi;
  }


  @JsonProperty(JSON_PROPERTY_DPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDpi(Integer dpi) {
    this.dpi = dpi;
  }


  public OperationToolboxPrintPrint expandToMargins(Boolean expandToMargins) {
    
    this.expandToMargins = expandToMargins;
    return this;
  }

  /**
   * If \&quot;true,\&quot; any PDF page that is smaller than the paper will be enlarged to fit the paper size.
   * @return expandToMargins
   **/
  @Nullable
  @Schema(name = "If \"true,\" any PDF page that is smaller than the paper will be enlarged to fit the paper size.")
  @JsonProperty(JSON_PROPERTY_EXPAND_TO_MARGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getExpandToMargins() {
    return expandToMargins;
  }


  @JsonProperty(JSON_PROPERTY_EXPAND_TO_MARGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpandToMargins(Boolean expandToMargins) {
    this.expandToMargins = expandToMargins;
  }


  public OperationToolboxPrintPrint jobName(String jobName) {
    
    this.jobName = jobName;
    return this;
  }

  /**
   * This attribute is used to define the name of the print job (as shown in the Print Spooler in Windows, for example).
   * @return jobName
   **/
  @Nullable
  @Schema(name = "This attribute is used to define the name of the print job (as shown in the Print Spooler in Windows, for example).")
  @JsonProperty(JSON_PROPERTY_JOB_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJobName() {
    return jobName;
  }


  @JsonProperty(JSON_PROPERTY_JOB_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobName(String jobName) {
    this.jobName = jobName;
  }


  public OperationToolboxPrintPrint mode(ModeEnum mode) {
    
    this.mode = mode;
    return this;
  }

  /**
   * Select the printing mode, that shall be used.  *   default &#x3D; The drawing operations are applied to the printout as defined in the PDF document. *   image &#x3D; Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result. *   raster &#x3D; Every page of the document is rastered before printing. This is a compatibility mode for older printers.
   * @return mode
   **/
  @Nullable
  @Schema(name = "Select the printing mode, that shall be used.  *   default = The drawing operations are applied to the printout as defined in the PDF document. *   image = Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result. *   raster = Every page of the document is rastered before printing. This is a compatibility mode for older printers.")
  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModeEnum getMode() {
    return mode;
  }


  @JsonProperty(JSON_PROPERTY_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMode(ModeEnum mode) {
    this.mode = mode;
  }


  public OperationToolboxPrintPrint pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Defines which page(s) should be printed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \&quot;1,5-6,9\&quot;). To specify \&quot;all pages,\&quot; use an asterisk (\&quot;\\*\&quot;).
   * @return pages
   **/
  @Nullable
  @Schema(name = "Defines which page(s) should be printed. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationToolboxPrintPrint printerName(String printerName) {
    
    this.printerName = printerName;
    return this;
  }

  /**
   * This attribute is used to specify the name of the printer that should be used to print the PDF document. If a printer is not declared, then the system&#39;s default printer will be used for printing.
   * @return printerName
   **/
  @Nullable
  @Schema(name = "This attribute is used to specify the name of the printer that should be used to print the PDF document. If a printer is not declared, then the system's default printer will be used for printing.")
  @JsonProperty(JSON_PROPERTY_PRINTER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrinterName() {
    return printerName;
  }


  @JsonProperty(JSON_PROPERTY_PRINTER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrinterName(String printerName) {
    this.printerName = printerName;
  }


  public OperationToolboxPrintPrint shrinkToMargins(Boolean shrinkToMargins) {
    
    this.shrinkToMargins = shrinkToMargins;
    return this;
  }

  /**
   * If \&quot;true,\&quot; any PDF page that is larger than the paper will be shrunk to fit the paper size.
   * @return shrinkToMargins
   **/
  @Nullable
  @Schema(name = "If \"true,\" any PDF page that is larger than the paper will be shrunk to fit the paper size.")
  @JsonProperty(JSON_PROPERTY_SHRINK_TO_MARGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShrinkToMargins() {
    return shrinkToMargins;
  }


  @JsonProperty(JSON_PROPERTY_SHRINK_TO_MARGINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShrinkToMargins(Boolean shrinkToMargins) {
    this.shrinkToMargins = shrinkToMargins;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxPrintPrint operationToolboxPrintPrint = (OperationToolboxPrintPrint) o;
    return Objects.equals(this.autoRotate, operationToolboxPrintPrint.autoRotate) &&
        Objects.equals(this.centerInPage, operationToolboxPrintPrint.centerInPage) &&
        Objects.equals(this.copies, operationToolboxPrintPrint.copies) &&
        Objects.equals(this.dpi, operationToolboxPrintPrint.dpi) &&
        Objects.equals(this.expandToMargins, operationToolboxPrintPrint.expandToMargins) &&
        Objects.equals(this.jobName, operationToolboxPrintPrint.jobName) &&
        Objects.equals(this.mode, operationToolboxPrintPrint.mode) &&
        Objects.equals(this.pages, operationToolboxPrintPrint.pages) &&
        Objects.equals(this.printerName, operationToolboxPrintPrint.printerName) &&
        Objects.equals(this.shrinkToMargins, operationToolboxPrintPrint.shrinkToMargins);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoRotate, centerInPage, copies, dpi, expandToMargins, jobName, mode, pages, printerName, shrinkToMargins);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxPrintPrint {\n");
    sb.append("    autoRotate: ").append(toIndentedString(autoRotate)).append("\n");
    sb.append("    centerInPage: ").append(toIndentedString(centerInPage)).append("\n");
    sb.append("    copies: ").append(toIndentedString(copies)).append("\n");
    sb.append("    dpi: ").append(toIndentedString(dpi)).append("\n");
    sb.append("    expandToMargins: ").append(toIndentedString(expandToMargins)).append("\n");
    sb.append("    jobName: ").append(toIndentedString(jobName)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    printerName: ").append(toIndentedString(printerName)).append("\n");
    sb.append("    shrinkToMargins: ").append(toIndentedString(shrinkToMargins)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
