/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to specify all the properties you want for a content structure entry that is to be created, including the actions it will trigger. An entry can contain any number of the specified subelements you want in the order you want them. All subelements represent a type of action that will be triggered when the entry is clicked on and that will be executed in succession.
 */
@Schema(description = "Used to specify all the properties you want for a content structure entry that is to be created, including the actions it will trigger. An entry can contain any number of the specified subelements you want in the order you want them. All subelements represent a type of action that will be triggered when the entry is clicked on and that will be executed in succession.")
@JsonPropertyOrder({
  OperationItem.JSON_PROPERTY_ACTIONS,
  OperationItem.JSON_PROPERTY_BOLD,
  OperationItem.JSON_PROPERTY_COLOR,
  OperationItem.JSON_PROPERTY_IS_OPEN,
  OperationItem.JSON_PROPERTY_ITALIC,
  OperationItem.JSON_PROPERTY_ITEM_NAME,
  OperationItem.JSON_PROPERTY_PATH,
  OperationItem.JSON_PROPERTY_PATH_POSITION
})
@JsonTypeName("Operation_Item")

public class OperationItem {
  public static final String JSON_PROPERTY_ACTIONS = "actions";
  private List<OperationActionEvent> actions = null;

  public static final String JSON_PROPERTY_BOLD = "bold";
  private Boolean bold = false;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#000000";

  public static final String JSON_PROPERTY_IS_OPEN = "isOpen";
  private Boolean isOpen = false;

  public static final String JSON_PROPERTY_ITALIC = "italic";
  private Boolean italic = false;

  public static final String JSON_PROPERTY_ITEM_NAME = "itemName";
  private String itemName = "";

  public static final String JSON_PROPERTY_PATH = "path";
  private String path = "";

  /**
   * Selects the position where the entry should be created. The path passed in \&quot;path\&quot; will be interpreted based on this value.  *   before &#x3D; An entry will be generated on the same level before the entry that was selected with \&quot;path. *   inplace &#x3D; The entry selected with \&quot;path\&quot; will be treated as a parent element and will contain the new generated entry. *   after &#x3D; An entry will be generated on the same level after the entry that was selected with \&quot;path.
   */
  public enum PathPositionEnum {
    BEFORE("before"),
    
    INPLACE("inplace"),
    
    AFTER("after");

    private String value;

    PathPositionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PathPositionEnum fromValue(String value) {
      for (PathPositionEnum b : PathPositionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PATH_POSITION = "pathPosition";
  private PathPositionEnum pathPosition = PathPositionEnum.INPLACE;

  public OperationItem() {
  }

  public OperationItem actions(List<OperationActionEvent> actions) {
    
    this.actions = actions;
    return this;
  }

  public OperationItem addActionsItem(OperationActionEvent actionsItem) {
    if (this.actions == null) {
      this.actions = new ArrayList<>();
    }
    this.actions.add(actionsItem);
    return this;
  }

  /**
   * Get actions
   * @return actions
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationActionEvent> getActions() {
    return actions;
  }


  @JsonProperty(JSON_PROPERTY_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActions(List<OperationActionEvent> actions) {
    this.actions = actions;
  }


  public OperationItem bold(Boolean bold) {
    
    this.bold = bold;
    return this;
  }

  /**
   * If this value is set to true, the element&#39;s name will be shown in bold.
   * @return bold
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the element's name will be shown in bold.")
  @JsonProperty(JSON_PROPERTY_BOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getBold() {
    return bold;
  }


  @JsonProperty(JSON_PROPERTY_BOLD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBold(Boolean bold) {
    this.bold = bold;
  }


  public OperationItem color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * Used to set the colour that will be used to display the element&#39;s name. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.
   * @return color
   **/
  @Nullable
  @Schema(name = "Used to set the colour that will be used to display the element's name. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public OperationItem isOpen(Boolean isOpen) {
    
    this.isOpen = isOpen;
    return this;
  }

  /**
   * If this value is set to true, the element will already be expanded when the document is opened.
   * @return isOpen
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the element will already be expanded when the document is opened.")
  @JsonProperty(JSON_PROPERTY_IS_OPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsOpen() {
    return isOpen;
  }


  @JsonProperty(JSON_PROPERTY_IS_OPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsOpen(Boolean isOpen) {
    this.isOpen = isOpen;
  }


  public OperationItem italic(Boolean italic) {
    
    this.italic = italic;
    return this;
  }

  /**
   * If this value is set to true, the element&#39;s name will be shown in italics.
   * @return italic
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the element's name will be shown in italics.")
  @JsonProperty(JSON_PROPERTY_ITALIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getItalic() {
    return italic;
  }


  @JsonProperty(JSON_PROPERTY_ITALIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItalic(Boolean italic) {
    this.italic = italic;
  }


  public OperationItem itemName(String itemName) {
    
    this.itemName = itemName;
    return this;
  }

  /**
   * The name of the new entry in the content structure that should be placed relative to the selected path.
   * @return itemName
   **/
  @Nullable
  @Schema(name = "The name of the new entry in the content structure that should be placed relative to the selected path.")
  @JsonProperty(JSON_PROPERTY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getItemName() {
    return itemName;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemName(String itemName) {
    this.itemName = itemName;
  }


  public OperationItem path(String path) {
    
    this.path = path;
    return this;
  }

  /**
   * The element paths are made of the visible names of the entries in the content structure separated with forward slashes (/), starting with an initial slash.
   * @return path
   **/
  @Nullable
  @Schema(name = "The element paths are made of the visible names of the entries in the content structure separated with forward slashes (/), starting with an initial slash.")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }


  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPath(String path) {
    this.path = path;
  }


  public OperationItem pathPosition(PathPositionEnum pathPosition) {
    
    this.pathPosition = pathPosition;
    return this;
  }

  /**
   * Selects the position where the entry should be created. The path passed in \&quot;path\&quot; will be interpreted based on this value.  *   before &#x3D; An entry will be generated on the same level before the entry that was selected with \&quot;path. *   inplace &#x3D; The entry selected with \&quot;path\&quot; will be treated as a parent element and will contain the new generated entry. *   after &#x3D; An entry will be generated on the same level after the entry that was selected with \&quot;path.
   * @return pathPosition
   **/
  @Nullable
  @Schema(name = "Selects the position where the entry should be created. The path passed in \"path\" will be interpreted based on this value.  *   before = An entry will be generated on the same level before the entry that was selected with \"path. *   inplace = The entry selected with \"path\" will be treated as a parent element and will contain the new generated entry. *   after = An entry will be generated on the same level after the entry that was selected with \"path.")
  @JsonProperty(JSON_PROPERTY_PATH_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PathPositionEnum getPathPosition() {
    return pathPosition;
  }


  @JsonProperty(JSON_PROPERTY_PATH_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPathPosition(PathPositionEnum pathPosition) {
    this.pathPosition = pathPosition;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationItem operationItem = (OperationItem) o;
    return Objects.equals(this.actions, operationItem.actions) &&
        Objects.equals(this.bold, operationItem.bold) &&
        Objects.equals(this.color, operationItem.color) &&
        Objects.equals(this.isOpen, operationItem.isOpen) &&
        Objects.equals(this.italic, operationItem.italic) &&
        Objects.equals(this.itemName, operationItem.itemName) &&
        Objects.equals(this.path, operationItem.path) &&
        Objects.equals(this.pathPosition, operationItem.pathPosition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actions, bold, color, isOpen, italic, itemName, path, pathPosition);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationItem {\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    bold: ").append(toIndentedString(bold)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    isOpen: ").append(toIndentedString(isOpen)).append("\n");
    sb.append("    italic: ").append(toIndentedString(italic)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    pathPosition: ").append(toIndentedString(pathPosition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
