/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to change properties of selected, already existing annotations.
 */
@Schema(description = "Used to change properties of selected, already existing annotations.")
@JsonPropertyOrder({
  OperationEditToolboxAnnotation.JSON_PROPERTY_CIRCLE,
  OperationEditToolboxAnnotation.JSON_PROPERTY_FREETEXT,
  OperationEditToolboxAnnotation.JSON_PROPERTY_LINE,
  OperationEditToolboxAnnotation.JSON_PROPERTY_MARKUP,
  OperationEditToolboxAnnotation.JSON_PROPERTY_REDACT,
  OperationEditToolboxAnnotation.JSON_PROPERTY_RUBBERSTAMP,
  OperationEditToolboxAnnotation.JSON_PROPERTY_SELECTION,
  OperationEditToolboxAnnotation.JSON_PROPERTY_SQUARE,
  OperationEditToolboxAnnotation.JSON_PROPERTY_TEXT
})
@JsonTypeName("Operation_EditToolboxAnnotation")

public class OperationEditToolboxAnnotation {
  public static final String JSON_PROPERTY_CIRCLE = "circle";
  private OperationCircleAnnotation circle;

  public static final String JSON_PROPERTY_FREETEXT = "freetext";
  private OperationFreeTextAnnotation freetext;

  public static final String JSON_PROPERTY_LINE = "line";
  private OperationLineAnnotation line;

  public static final String JSON_PROPERTY_MARKUP = "markup";
  private OperationMarkupAnnotation markup;

  public static final String JSON_PROPERTY_REDACT = "redact";
  private OperationRedactAnnotation redact;

  public static final String JSON_PROPERTY_RUBBERSTAMP = "rubberstamp";
  private OperationRubberStampAnnotation rubberstamp;

  public static final String JSON_PROPERTY_SELECTION = "selection";
  private OperationSelectionEdit selection;

  public static final String JSON_PROPERTY_SQUARE = "square";
  private OperationSquareAnnotation square;

  public static final String JSON_PROPERTY_TEXT = "text";
  private OperationTextAnnotation text;

  public OperationEditToolboxAnnotation() {
  }

  public OperationEditToolboxAnnotation circle(OperationCircleAnnotation circle) {
    
    this.circle = circle;
    return this;
  }

  /**
   * Get circle
   * @return circle
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CIRCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationCircleAnnotation getCircle() {
    return circle;
  }


  @JsonProperty(JSON_PROPERTY_CIRCLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCircle(OperationCircleAnnotation circle) {
    this.circle = circle;
  }


  public OperationEditToolboxAnnotation freetext(OperationFreeTextAnnotation freetext) {
    
    this.freetext = freetext;
    return this;
  }

  /**
   * Get freetext
   * @return freetext
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FREETEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationFreeTextAnnotation getFreetext() {
    return freetext;
  }


  @JsonProperty(JSON_PROPERTY_FREETEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFreetext(OperationFreeTextAnnotation freetext) {
    this.freetext = freetext;
  }


  public OperationEditToolboxAnnotation line(OperationLineAnnotation line) {
    
    this.line = line;
    return this;
  }

  /**
   * Get line
   * @return line
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationLineAnnotation getLine() {
    return line;
  }


  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLine(OperationLineAnnotation line) {
    this.line = line;
  }


  public OperationEditToolboxAnnotation markup(OperationMarkupAnnotation markup) {
    
    this.markup = markup;
    return this;
  }

  /**
   * Get markup
   * @return markup
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationMarkupAnnotation getMarkup() {
    return markup;
  }


  @JsonProperty(JSON_PROPERTY_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkup(OperationMarkupAnnotation markup) {
    this.markup = markup;
  }


  public OperationEditToolboxAnnotation redact(OperationRedactAnnotation redact) {
    
    this.redact = redact;
    return this;
  }

  /**
   * Get redact
   * @return redact
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationRedactAnnotation getRedact() {
    return redact;
  }


  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedact(OperationRedactAnnotation redact) {
    this.redact = redact;
  }


  public OperationEditToolboxAnnotation rubberstamp(OperationRubberStampAnnotation rubberstamp) {
    
    this.rubberstamp = rubberstamp;
    return this;
  }

  /**
   * Get rubberstamp
   * @return rubberstamp
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_RUBBERSTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationRubberStampAnnotation getRubberstamp() {
    return rubberstamp;
  }


  @JsonProperty(JSON_PROPERTY_RUBBERSTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRubberstamp(OperationRubberStampAnnotation rubberstamp) {
    this.rubberstamp = rubberstamp;
  }


  public OperationEditToolboxAnnotation selection(OperationSelectionEdit selection) {
    
    this.selection = selection;
    return this;
  }

  /**
   * Get selection
   * @return selection
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OperationSelectionEdit getSelection() {
    return selection;
  }


  @JsonProperty(JSON_PROPERTY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSelection(OperationSelectionEdit selection) {
    this.selection = selection;
  }


  public OperationEditToolboxAnnotation square(OperationSquareAnnotation square) {
    
    this.square = square;
    return this;
  }

  /**
   * Get square
   * @return square
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SQUARE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSquareAnnotation getSquare() {
    return square;
  }


  @JsonProperty(JSON_PROPERTY_SQUARE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSquare(OperationSquareAnnotation square) {
    this.square = square;
  }


  public OperationEditToolboxAnnotation text(OperationTextAnnotation text) {
    
    this.text = text;
    return this;
  }

  /**
   * Get text
   * @return text
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationTextAnnotation getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(OperationTextAnnotation text) {
    this.text = text;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationEditToolboxAnnotation operationEditToolboxAnnotation = (OperationEditToolboxAnnotation) o;
    return Objects.equals(this.circle, operationEditToolboxAnnotation.circle) &&
        Objects.equals(this.freetext, operationEditToolboxAnnotation.freetext) &&
        Objects.equals(this.line, operationEditToolboxAnnotation.line) &&
        Objects.equals(this.markup, operationEditToolboxAnnotation.markup) &&
        Objects.equals(this.redact, operationEditToolboxAnnotation.redact) &&
        Objects.equals(this.rubberstamp, operationEditToolboxAnnotation.rubberstamp) &&
        Objects.equals(this.selection, operationEditToolboxAnnotation.selection) &&
        Objects.equals(this.square, operationEditToolboxAnnotation.square) &&
        Objects.equals(this.text, operationEditToolboxAnnotation.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(circle, freetext, line, markup, redact, rubberstamp, selection, square, text);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationEditToolboxAnnotation {\n");
    sb.append("    circle: ").append(toIndentedString(circle)).append("\n");
    sb.append("    freetext: ").append(toIndentedString(freetext)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    markup: ").append(toIndentedString(markup)).append("\n");
    sb.append("    redact: ").append(toIndentedString(redact)).append("\n");
    sb.append("    rubberstamp: ").append(toIndentedString(rubberstamp)).append("\n");
    sb.append("    selection: ").append(toIndentedString(selection)).append("\n");
    sb.append("    square: ").append(toIndentedString(square)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
